/*
 * Decompiled with CFR 0.152.
 */
package com.etfl.warputils.features.back.data;

import com.etfl.warputils.common.abstraction.config.nbt.NbtCompound;
import com.etfl.warputils.common.data.Location;
import com.etfl.warputils.features.back.config.BackConfig;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

public class BackData {
    private long expirationTime;
    private Location location;
    private static final String DURATION_KEY = "duration";
    private static final String LOCATION_KEY = "location";

    private BackData() {
    }

    BackData(Location location, long currentTime) {
        this.location = location;
        this.expirationTime = BackConfig.getDuration() != 0 ? currentTime + (long)BackConfig.getDuration() : 0L;
    }

    public boolean isActive(long currentTime) {
        return this.expirationTime == 0L || this.expirationTime >= currentTime;
    }

    public Location getLocation() {
        return this.location;
    }

    @NotNull
    public NbtCompound toNbt() {
        NbtCompound nbt = new NbtCompound();
        nbt.putLong(DURATION_KEY, this.expirationTime);
        nbt.putCompound(LOCATION_KEY, this.location.toNbt());
        return nbt;
    }

    public static Optional<BackData> fromNbt(@NotNull NbtCompound nbt) {
        BackData backData = new BackData();
        backData.expirationTime = nbt.getLong(DURATION_KEY).orElse(-1L);
        if (backData.expirationTime < 0L) {
            return Optional.empty();
        }
        NbtCompound location = nbt.getCompound(LOCATION_KEY).orElse(null);
        if (location == null) {
            return Optional.empty();
        }
        backData.location = Location.fromNbt(location).orElse(null);
        if (backData.location == null) {
            return Optional.empty();
        }
        return Optional.of(backData);
    }
}

