/*
 * Decompiled with CFR 0.152.
 */
package com.etfl.warputils.features.homes.commands;

import com.etfl.warputils.common.abstraction.commands.ArgumentCommandBuilder;
import com.etfl.warputils.common.abstraction.commands.LiteralCommandBuilder;
import com.etfl.warputils.common.abstraction.commands.wrappers.CommandContextWrapper;
import com.etfl.warputils.common.abstraction.commands.wrappers.CommandSourceWrapper;
import com.etfl.warputils.common.abstraction.commands.wrappers.argumentTypes.StringArgumentWrapper;
import com.etfl.warputils.common.abstraction.objects.ServerPlayerWrapper;
import com.etfl.warputils.common.language.MessageManager;
import com.etfl.warputils.common.utils.DataSaver;
import com.etfl.warputils.common.utils.EventBus;
import com.etfl.warputils.common.utils.FeatureValidator;
import com.etfl.warputils.features.homes.HomesHelper;
import com.etfl.warputils.features.homes.HomesRegistry;
import com.etfl.warputils.features.homes.data.HomesManager;

public class SetdefaulthomeCommand {
    private SetdefaulthomeCommand() {
        throw new UnsupportedOperationException("Utility class");
    }

    public static void register() {
        EventBus.addCommand((LiteralCommandBuilder)((LiteralCommandBuilder)LiteralCommandBuilder.literal("setdefaulthome").requires(CommandSourceWrapper::isPlayer)).then(ArgumentCommandBuilder.argument("homeName", StringArgumentWrapper.word()).suggests(HomesRegistry.SUGGESTION_PROVIDER).executes(SetdefaulthomeCommand::run)));
    }

    private static int run(CommandContextWrapper context) {
        ServerPlayerWrapper player = context.getSource().getPlayer();
        String homeName = StringArgumentWrapper.getString(context, "homeName");
        if (FeatureValidator.disabled(FeatureValidator.Feature.Home, player)) {
            return 0;
        }
        if (HomesHelper.noHomes(player)) {
            return 0;
        }
        if (HomesHelper.invalidHomeCount(player)) {
            return 0;
        }
        if (HomesManager.setDefaultHome(player.getUUID(), homeName)) {
            DataSaver.markDirty();
        }
        MessageManager.sendMessage(player, "feature.homes.default_set", false, homeName);
        return 1;
    }
}

