/*
 * Decompiled with CFR 0.152.
 */
package com.etfl.warputils.features.homes.commands;

import com.etfl.warputils.common.abstraction.commands.ArgumentCommandBuilder;
import com.etfl.warputils.common.abstraction.commands.LiteralCommandBuilder;
import com.etfl.warputils.common.abstraction.commands.wrappers.CommandContextWrapper;
import com.etfl.warputils.common.abstraction.commands.wrappers.CommandSourceWrapper;
import com.etfl.warputils.common.abstraction.commands.wrappers.argumentTypes.StringArgumentWrapper;
import com.etfl.warputils.common.abstraction.objects.ServerPlayerWrapper;
import com.etfl.warputils.common.language.MessageManager;
import com.etfl.warputils.common.utils.DataSaver;
import com.etfl.warputils.common.utils.EventBus;
import com.etfl.warputils.common.utils.FeatureValidator;
import com.etfl.warputils.features.homes.HomesConfig;
import com.etfl.warputils.features.homes.HomesHelper;
import com.etfl.warputils.features.homes.HomesRegistry;
import com.etfl.warputils.features.homes.data.HomesManager;
import java.util.UUID;

public class SethomeCommand {
    private SethomeCommand() {
        throw new UnsupportedOperationException("Utility class");
    }

    public static void register() {
        EventBus.addCommand((LiteralCommandBuilder)((LiteralCommandBuilder)LiteralCommandBuilder.literal("sethome").requires(CommandSourceWrapper::isPlayer)).then(ArgumentCommandBuilder.argument("homeName", StringArgumentWrapper.word()).suggests(HomesRegistry.SUGGESTION_PROVIDER).executes(SethomeCommand::run)));
    }

    private static int run(CommandContextWrapper context) {
        ServerPlayerWrapper player = context.getSource().getPlayer();
        String homeName = StringArgumentWrapper.getString(context, "homeName");
        if (FeatureValidator.disabled(FeatureValidator.Feature.Home, player)) {
            return 0;
        }
        if (HomesHelper.invalidHomeCount(player)) {
            return 0;
        }
        int maxHomeCount = HomesConfig.getMaxHomeCount();
        UUID uuid = player.getUUID();
        if (HomesConfig.getMaxHomeCount() != 0 && HomesManager.getCount(uuid) >= maxHomeCount && HomesManager.get(uuid, homeName) == null) {
            MessageManager.sendMessage(player, "feature.homes.limit_reached", false, new Object[0]);
            return 0;
        }
        HomesManager.addHome(uuid, homeName, player.getLocation());
        DataSaver.markDirty();
        MessageManager.sendMessage(player, "feature.homes.set", false, homeName);
        return 1;
    }
}

