/*
 * Decompiled with CFR 0.152.
 */
package com.etfl.warputils.features.homes.data;

import com.etfl.warputils.common.abstraction.config.nbt.NbtCompound;
import com.etfl.warputils.common.data.Location;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

class HomesData {
    private String defaultHomeName = "";
    private final Map<String, Location> homes = new HashMap<String, Location>();
    private static final String DEFAULT_HOME_KEY = "default_home";
    private static final String HOMES_KEY = "homes";

    HomesData() {
    }

    public Location get(String homeName) {
        return this.homes.get(homeName);
    }

    public String[] get() {
        return (String[])this.homes.keySet().toArray(String[]::new);
    }

    public String getDefaultHomeName() {
        if (this.homes.isEmpty()) {
            this.defaultHomeName = "";
        } else if (this.homes.get(this.defaultHomeName) == null) {
            this.defaultHomeName = ((String[])this.homes.keySet().toArray(String[]::new))[0];
        }
        return this.defaultHomeName;
    }

    public int getCount() {
        return this.homes.size();
    }

    public void addHome(String homeName, Location location) {
        this.homes.put(homeName, location);
    }

    public boolean removeHome(String homeName) {
        return this.homes.remove(homeName) != null;
    }

    public boolean setDefaultHome(String homeName) {
        if (!this.homes.containsKey(homeName)) {
            return false;
        }
        this.defaultHomeName = homeName;
        return true;
    }

    @NotNull
    public NbtCompound toNbt() {
        NbtCompound nbt = new NbtCompound();
        nbt.putString(DEFAULT_HOME_KEY, this.defaultHomeName);
        NbtCompound homes = new NbtCompound();
        for (String key : this.homes.keySet()) {
            homes.putCompound(key, this.homes.get(key).toNbt());
        }
        nbt.putCompound(HOMES_KEY, homes);
        return nbt;
    }

    @NotNull
    public static HomesData fromNbt(@NotNull NbtCompound nbt) {
        HomesData homesData = new HomesData();
        homesData.defaultHomeName = nbt.getString(DEFAULT_HOME_KEY).orElse("");
        Optional<NbtCompound> homesOptional = nbt.getCompound(HOMES_KEY);
        if (homesOptional.isEmpty()) {
            return homesData;
        }
        NbtCompound homesNbt = homesOptional.get();
        for (String key : homesNbt.getKeys()) {
            homesNbt.getCompound(key).flatMap(Location::fromNbt).ifPresent(location -> homesData.homes.put(key, (Location)location));
        }
        return homesData;
    }
}

