/*
 * Decompiled with CFR 0.152.
 */
package com.etfl.warputils.features.tpas;

import com.etfl.warputils.common.abstraction.commands.wrappers.argumentTypes.BoolArgumentWrapper;
import com.etfl.warputils.common.abstraction.commands.wrappers.argumentTypes.TimeArgumentWrapper;
import com.etfl.warputils.common.abstraction.config.categories.ConfigCategory;
import com.etfl.warputils.common.abstraction.config.categories.SimpleConfigCategory;
import com.etfl.warputils.common.abstraction.config.settings.BoolConfigSetting;
import com.etfl.warputils.common.abstraction.config.settings.IntConfigSetting;
import com.etfl.warputils.features.general.GeneralConfig;

public class TpaConfig {
    private static final IntConfigSetting cooldown = new IntConfigSetting("cooldown", TimeArgumentWrapper.time(-1), -1, value -> value >= -1);
    private static final IntConfigSetting delay = new IntConfigSetting("delay", TimeArgumentWrapper.time(-1), -1, value -> value >= -1);
    private static final IntConfigSetting duration = new IntConfigSetting("duration", TimeArgumentWrapper.time(0), 6000, value -> value >= 0);
    private static final BoolConfigSetting disableTpas = new BoolConfigSetting("disableTpas", BoolArgumentWrapper.bool(), false);
    public static final ConfigCategory category = new SimpleConfigCategory("tpas").add(cooldown).add(delay).add(duration).add(disableTpas);

    private TpaConfig() {
        throw new UnsupportedOperationException("Utility class");
    }

    public static int getCooldown() {
        return (Integer)cooldown.get() > -1 ? (Integer)cooldown.get() : GeneralConfig.getCooldown();
    }

    public static int getDelay() {
        return (Integer)delay.get() > -1 ? (Integer)delay.get() : GeneralConfig.getDelay();
    }

    public static int getDuration() {
        return (Integer)duration.get();
    }

    public static boolean areTpasDisabled() {
        return (Boolean)disableTpas.get();
    }
}

