/*
 * Decompiled with CFR 0.152.
 */
package com.etfl.warputils.features.tpas.commands;

import com.etfl.warputils.common.abstraction.commands.ArgumentCommandBuilder;
import com.etfl.warputils.common.abstraction.commands.LiteralCommandBuilder;
import com.etfl.warputils.common.abstraction.commands.wrappers.CommandContextWrapper;
import com.etfl.warputils.common.abstraction.commands.wrappers.CommandSourceWrapper;
import com.etfl.warputils.common.abstraction.commands.wrappers.ISuggestionProvider;
import com.etfl.warputils.common.abstraction.commands.wrappers.argumentTypes.EntityArgumentWrapper;
import com.etfl.warputils.common.abstraction.objects.ServerPlayerWrapper;
import com.etfl.warputils.common.language.MessageManager;
import com.etfl.warputils.common.utils.DataSaver;
import com.etfl.warputils.common.utils.EventBus;
import com.etfl.warputils.common.utils.FeatureValidator;
import com.etfl.warputils.common.utils.PlayerHelper;
import com.etfl.warputils.common.utils.timer.cooldown.CooldownManager;
import com.etfl.warputils.common.utils.timer.cooldown.CooldownType;
import com.etfl.warputils.common.utils.timer.delay.DelayManager;
import com.etfl.warputils.common.utils.timer.delay.DelayType;
import com.etfl.warputils.common.utils.timer.fightCooldown.FightCooldownManager;
import com.etfl.warputils.features.back.data.BackManager;
import com.etfl.warputils.features.tpas.data.Tpa;
import com.etfl.warputils.features.tpas.data.TpaManager;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import net.minecraft.commands.SharedSuggestionProvider;

public class TpaacceptCommand {
    private static final ISuggestionProvider<CommandContextWrapper> SUGGESTION_PROVIDER = (context, builder) -> SharedSuggestionProvider.suggest(TpaacceptCommand.getOnlineSenders(context), (SuggestionsBuilder)builder);

    private TpaacceptCommand() {
        throw new UnsupportedOperationException("Utility class");
    }

    public static void register() {
        EventBus.addCommand((LiteralCommandBuilder)((LiteralCommandBuilder)((LiteralCommandBuilder)LiteralCommandBuilder.literal("tpaaccept").requires(CommandSourceWrapper::isPlayer)).executes(TpaacceptCommand::acceptAll)).then(ArgumentCommandBuilder.argument("player", EntityArgumentWrapper.player()).suggests(SUGGESTION_PROVIDER).executes(TpaacceptCommand::accept)));
    }

    private static List<String> getOnlineSenders(CommandContextWrapper context) {
        UUID receiver = context.getSource().getPlayer().getUUID();
        Set<UUID> uuids = TpaManager.getSenders(receiver);
        return context.getSource().getServer().getPlayerList().getPlayers().stream().filter(player -> uuids.contains(player.getUUID())).map(player -> player.getName().getString()).toList();
    }

    private static int acceptAll(CommandContextWrapper context) {
        ServerPlayerWrapper player = context.getSource().getPlayer();
        if (FeatureValidator.disabled(FeatureValidator.Feature.Tpa, player)) {
            return 0;
        }
        Set<UUID> uuids = TpaManager.getSenders(player.getUUID());
        if (uuids.isEmpty()) {
            return TpaacceptCommand.nonReceived(player);
        }
        for (UUID uuid : uuids) {
            ServerPlayerWrapper sender = PlayerHelper.getPlayer(player.getServer(), uuid);
            if (sender == null || FightCooldownManager.onCooldown(sender)) continue;
            TpaManager.removeTpa(uuid);
            MessageManager.sendMessage(player, "feature.tpa.accepted_sender", true, new Object[0]);
            DelayManager.startDelay(DelayType.Tpa, sender, player1 -> TpaacceptCommand.teleport(player1, player));
        }
        MessageManager.sendMessage(player, "feature.tpa.accepted_all", false, new Object[0]);
        return 1;
    }

    private static int nonReceived(ServerPlayerWrapper player) {
        MessageManager.sendMessage(player, "feature.tpa.none_received", false, new Object[0]);
        return 0;
    }

    private static int accept(CommandContextWrapper context) throws CommandSyntaxException {
        ServerPlayerWrapper player = context.getSource().getPlayer();
        ServerPlayerWrapper sender = EntityArgumentWrapper.getPlayer(context, "player");
        if (FeatureValidator.disabled(FeatureValidator.Feature.Tpa, player)) {
            return 0;
        }
        Tpa tpa = TpaManager.sentBy(sender.getUUID());
        if (tpa == null || !tpa.uuid.equals(player.getUUID())) {
            return TpaacceptCommand.noneReceivedFrom(player);
        }
        if (FightCooldownManager.onCooldown(sender)) {
            return 0;
        }
        TpaManager.removeTpa(sender.getUUID());
        DelayManager.startDelay(DelayType.Tpa, sender, player1 -> TpaacceptCommand.teleport(player1, player));
        MessageManager.sendMessage(player, "feature.tpa.accepted", false, sender.getName());
        MessageManager.sendMessage(sender, "feature.tpa.accepted_sender", true, new Object[0]);
        return 1;
    }

    private static int noneReceivedFrom(ServerPlayerWrapper player) {
        MessageManager.sendMessage(player, "feature.tpa.none_received_from", false, new Object[0]);
        return 0;
    }

    private static void teleport(ServerPlayerWrapper player, ServerPlayerWrapper target) {
        BackManager.add(player);
        player.teleport(target.getLocation());
        CooldownManager.startCooldown(CooldownType.Tpa, player);
        MessageManager.sendMessage(player, "feature.tpa.teleported", false, target.getName());
        DataSaver.markDirty();
    }
}

