/*
 * Decompiled with CFR 0.152.
 */
package com.etfl.warputils.features.tpas.commands;

import com.etfl.warputils.common.abstraction.commands.ArgumentCommandBuilder;
import com.etfl.warputils.common.abstraction.commands.LiteralCommandBuilder;
import com.etfl.warputils.common.abstraction.commands.wrappers.CommandContextWrapper;
import com.etfl.warputils.common.abstraction.commands.wrappers.CommandSourceWrapper;
import com.etfl.warputils.common.abstraction.commands.wrappers.ISuggestionProvider;
import com.etfl.warputils.common.abstraction.commands.wrappers.argumentTypes.EntityArgumentWrapper;
import com.etfl.warputils.common.abstraction.objects.ServerPlayerWrapper;
import com.etfl.warputils.common.language.MessageManager;
import com.etfl.warputils.common.utils.EventBus;
import com.etfl.warputils.common.utils.FeatureValidator;
import com.etfl.warputils.common.utils.PlayerHelper;
import com.etfl.warputils.features.tpas.data.Tpa;
import com.etfl.warputils.features.tpas.data.TpaManager;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.server.MinecraftServer;

public class TpadenyCommand {
    private static final ISuggestionProvider<CommandContextWrapper> SUGGESTION_PROVIDER = (context, builder) -> SharedSuggestionProvider.suggest(TpadenyCommand.getSenders(context), (SuggestionsBuilder)builder);

    private TpadenyCommand() {
        throw new UnsupportedOperationException("Utility class");
    }

    public static void register() {
        EventBus.addCommand((LiteralCommandBuilder)((LiteralCommandBuilder)((LiteralCommandBuilder)LiteralCommandBuilder.literal("tpadeny").requires(CommandSourceWrapper::isPlayer)).executes(TpadenyCommand::denyAll)).then(ArgumentCommandBuilder.argument("player", EntityArgumentWrapper.player()).suggests(SUGGESTION_PROVIDER).executes(TpadenyCommand::deny)));
    }

    private static List<String> getSenders(CommandContextWrapper context) {
        UUID receiver = context.getSource().getPlayer().getUUID();
        Set<UUID> uuids = TpaManager.getSenders(receiver);
        MinecraftServer server = context.getSource().getServer();
        return uuids.stream().map(uuid -> PlayerHelper.getPlayerName(server, uuid)).toList();
    }

    private static int denyAll(CommandContextWrapper context) {
        ServerPlayerWrapper player = context.getSource().getPlayer();
        if (FeatureValidator.disabled(FeatureValidator.Feature.Tpa, player)) {
            return 0;
        }
        Set<UUID> uuids = TpaManager.getSenders(player.getUUID());
        if (uuids.isEmpty()) {
            return TpadenyCommand.nonReceived(player);
        }
        for (UUID uuid : uuids) {
            ServerPlayerWrapper sender = PlayerHelper.getPlayer(player.getServer(), uuid);
            TpaManager.removeTpa(uuid);
            if (sender == null) continue;
            MessageManager.sendMessage(player, "feature.tpa.denied_sender", true, new Object[0]);
        }
        MessageManager.sendMessage(player, "feature.tpa.denied_all", false, new Object[0]);
        return 1;
    }

    private static int nonReceived(ServerPlayerWrapper player) {
        MessageManager.sendMessage(player, "feature.tpa.none_received", false, new Object[0]);
        return 0;
    }

    private static int deny(CommandContextWrapper context) throws CommandSyntaxException {
        ServerPlayerWrapper player = context.getSource().getPlayer();
        ServerPlayerWrapper sender = EntityArgumentWrapper.getPlayer(context, "player");
        if (FeatureValidator.disabled(FeatureValidator.Feature.Tpa, player)) {
            return 0;
        }
        Tpa tpa = TpaManager.sentBy(sender.getUUID());
        if (tpa == null || !tpa.uuid.equals(player.getUUID())) {
            return TpadenyCommand.nonReceivedFrom(player, sender.getName());
        }
        TpaManager.removeTpa(sender.getUUID());
        MessageManager.sendMessage(player, "feature.tpa.denied", false, sender.getName());
        MessageManager.sendMessage(sender, "feature.tpa.denied_sender", true, new Object[0]);
        return 1;
    }

    private static int nonReceivedFrom(ServerPlayerWrapper player, String senderName) {
        MessageManager.sendMessage(player, "feature.tpa.none_received_from", false, senderName);
        return 0;
    }
}

