/*
 * Decompiled with CFR 0.152.
 */
package com.etfl.warputils.features.tpas.commands;

import com.etfl.warputils.common.abstraction.commands.LiteralCommandBuilder;
import com.etfl.warputils.common.abstraction.commands.wrappers.CommandContextWrapper;
import com.etfl.warputils.common.abstraction.commands.wrappers.CommandSourceWrapper;
import com.etfl.warputils.common.abstraction.objects.ServerPlayerWrapper;
import com.etfl.warputils.common.language.MessageManager;
import com.etfl.warputils.common.utils.EventBus;
import com.etfl.warputils.common.utils.FeatureValidator;
import com.etfl.warputils.common.utils.PlayerHelper;
import com.etfl.warputils.features.tpas.data.Tpa;
import com.etfl.warputils.features.tpas.data.TpaManager;
import java.util.Set;
import java.util.UUID;
import net.minecraft.network.chat.Component;

public class TpasCommand {
    private TpasCommand() {
        throw new UnsupportedOperationException("Utility class");
    }

    public static void register() {
        EventBus.addCommand((LiteralCommandBuilder)((LiteralCommandBuilder)LiteralCommandBuilder.literal("tpas").requires(CommandSourceWrapper::isPlayer)).executes(TpasCommand::run));
    }

    private static int run(CommandContextWrapper context) {
        ServerPlayerWrapper player = context.getSource().getPlayer();
        if (FeatureValidator.disabled(FeatureValidator.Feature.Tpa, player)) {
            return 0;
        }
        Tpa sent = TpaManager.sentBy(player.getUUID());
        Set<UUID> received = TpaManager.getSenders(player.getUUID());
        if (sent == null && received.isEmpty()) {
            return TpasCommand.noTpas(player);
        }
        MessageManager.sendMessage(player, "feature.tpa.list_begin", true, new Object[0]);
        if (sent != null) {
            MessageManager.sendMessage(player, TpasCommand.tpaSent(player.getUUID(), PlayerHelper.getPlayerName(player.getServer(), sent.uuid)), true);
        }
        for (UUID uuid : received) {
            MessageManager.sendMessage(player, TpasCommand.tpaReceived(player.getUUID(), PlayerHelper.getPlayerName(player.getServer(), uuid)), true);
        }
        return 1;
    }

    private static int noTpas(ServerPlayerWrapper player) {
        MessageManager.sendMessage(player, "feature.tpa.no_tpas", false, new Object[0]);
        return 0;
    }

    private static Component tpaSent(UUID uuid, String targetName) {
        return MessageManager.getMessage(uuid, "feature.tpa.list_sent", targetName).append(MessageManager.clickable(uuid, "feature.tpa.sent_cancel", "/tpacancel"));
    }

    private static Component tpaReceived(UUID uuid, String sender) {
        return MessageManager.getMessage(uuid, "feature.tpa.list_received", sender).append(MessageManager.clickable(uuid, "feature.tpa.received_accept", "/tpaaccept " + sender)).append(" ").append(MessageManager.clickable(uuid, "feature.tpa.received_deny", "/tpadeny " + sender));
    }
}

