/*
 * Decompiled with CFR 0.152.
 */
package com.etfl.warputils.features.tpas.data;

import com.etfl.warputils.common.abstraction.objects.ServerPlayerWrapper;
import com.etfl.warputils.common.language.MessageManager;
import com.etfl.warputils.common.utils.EventBus;
import com.etfl.warputils.common.utils.PlayerHelper;
import com.etfl.warputils.features.tpas.data.Tpa;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.NotNull;

public class TpaManager {
    private static final Map<UUID, Tpa> tpas = new HashMap<UUID, Tpa>();

    private TpaManager() {
        throw new UnsupportedOperationException("Utility class");
    }

    public static void register() {
        EventBus.registerTickEvents(TpaManager::onTick);
    }

    private static void onTick(@NotNull MinecraftServer server) {
        if (tpas.isEmpty()) {
            return;
        }
        tpas.entrySet().removeIf(entry -> TpaManager.isExpired(entry, server));
        tpas.values().forEach(Tpa::onTick);
    }

    private static boolean isExpired(Map.Entry<UUID, Tpa> entry, MinecraftServer server) {
        if (entry.getValue().isActive()) {
            return false;
        }
        ServerPlayerWrapper player = PlayerHelper.getPlayer(server, entry.getKey());
        if (player == null) {
            return true;
        }
        MessageManager.sendMessage(player, "feature.tpa.expired", true, new Object[0]);
        return true;
    }

    public static Tpa addTpa(UUID sender, @NotNull ServerPlayerWrapper receiver) {
        return tpas.put(sender, new Tpa(receiver));
    }

    public static Tpa removeTpa(UUID sender) {
        return tpas.remove(sender);
    }

    public static void reset() {
        tpas.clear();
    }

    public static Tpa[] receivedBy(UUID receiver) {
        return (Tpa[])tpas.values().stream().filter(tpa -> tpa.uuid.equals(receiver)).toArray(Tpa[]::new);
    }

    public static Tpa sentBy(UUID uuid) {
        return tpas.get(uuid);
    }

    public static UUID getSender(Tpa tpa) {
        return tpas.entrySet().stream().filter(entry -> ((Tpa)entry.getValue()).equals(tpa)).map(Map.Entry::getKey).findFirst().orElse(null);
    }

    public static Set<UUID> getSenders(UUID receiver) {
        return tpas.entrySet().stream().filter(entry -> ((Tpa)entry.getValue()).uuid.equals(receiver)).map(Map.Entry::getKey).collect(Collectors.toCollection(HashSet::new));
    }
}

