/*
 * Decompiled with CFR 0.152.
 */
package com.etfl.warputils.features.warps;

import com.etfl.warputils.common.abstraction.commands.wrappers.argumentTypes.BoolArgumentWrapper;
import com.etfl.warputils.common.abstraction.commands.wrappers.argumentTypes.TimeArgumentWrapper;
import com.etfl.warputils.common.abstraction.config.categories.ConfigCategory;
import com.etfl.warputils.common.abstraction.config.categories.SimpleConfigCategory;
import com.etfl.warputils.common.abstraction.config.settings.BoolConfigSetting;
import com.etfl.warputils.common.abstraction.config.settings.IntConfigSetting;
import com.etfl.warputils.features.general.GeneralConfig;

public class WarpConfig {
    private static final IntConfigSetting cooldown = new IntConfigSetting("cooldown", TimeArgumentWrapper.time(-1), -1, value -> value >= -1);
    private static final IntConfigSetting delay = new IntConfigSetting("delay", TimeArgumentWrapper.time(-1), -1, value -> value >= -1);
    private static final BoolConfigSetting disableSpawnWarp = new BoolConfigSetting("disableSpawnWarp", BoolArgumentWrapper.bool(), false);
    private static final BoolConfigSetting disableWarps = new BoolConfigSetting("disableWarps", BoolArgumentWrapper.bool(), false);
    public static final ConfigCategory category = new SimpleConfigCategory("warp").add(cooldown).add(delay).add(disableSpawnWarp).add(disableWarps);

    private WarpConfig() {
        throw new UnsupportedOperationException("Utility class");
    }

    public static int getCooldown() {
        return (Integer)cooldown.get() > -1 ? (Integer)cooldown.get() : GeneralConfig.getCooldown();
    }

    public static int getDelay() {
        return (Integer)delay.get() > -1 ? (Integer)delay.get() : GeneralConfig.getDelay();
    }

    public static boolean isSpawnWarpDisabled() {
        return (Boolean)disableSpawnWarp.get();
    }

    public static boolean areWarpsDisabled() {
        return (Boolean)disableWarps.get();
    }
}

