/*
 * Decompiled with CFR 0.152.
 */
package com.etfl.warputils.features.warps;

import com.etfl.warputils.common.abstraction.commands.wrappers.CommandContextWrapper;
import com.etfl.warputils.common.abstraction.commands.wrappers.ISuggestionProvider;
import com.etfl.warputils.features.warps.WarpConfig;
import com.etfl.warputils.features.warps.commands.DelwarpCommand;
import com.etfl.warputils.features.warps.commands.RenamewarpCommand;
import com.etfl.warputils.features.warps.commands.SetwarpCommand;
import com.etfl.warputils.features.warps.commands.WarpCommand;
import com.etfl.warputils.features.warps.commands.WarpsCommand;
import com.etfl.warputils.features.warps.data.WarpManager;

public class WarpRegistry {
    public static final String SPAWN_WARP = "Spawn";

    private WarpRegistry() {
        throw new UnsupportedOperationException("Utility class");
    }

    public static void register() {
        DelwarpCommand.register();
        RenamewarpCommand.register();
        SetwarpCommand.register();
        WarpCommand.register();
        WarpsCommand.register();
    }

    public static ISuggestionProvider<CommandContextWrapper> SUGGESTION_PROVIDER(boolean includeSpawn) {
        return (context, builder) -> {
            String[] warps;
            for (String warpName : warps = WarpManager.get()) {
                builder.suggest(warpName);
            }
            if (!WarpConfig.isSpawnWarpDisabled() && includeSpawn) {
                builder.suggest(SPAWN_WARP);
            }
            return builder.buildFuture();
        };
    }
}

