/*
 * Decompiled with CFR 0.152.
 */
package com.etfl.warputils.features.warps.commands;

import com.etfl.warputils.common.abstraction.commands.ArgumentCommandBuilder;
import com.etfl.warputils.common.abstraction.commands.LiteralCommandBuilder;
import com.etfl.warputils.common.abstraction.commands.wrappers.CommandContextWrapper;
import com.etfl.warputils.common.abstraction.commands.wrappers.CommandSourceWrapper;
import com.etfl.warputils.common.abstraction.commands.wrappers.argumentTypes.StringArgumentWrapper;
import com.etfl.warputils.common.abstraction.objects.ServerPlayerWrapper;
import com.etfl.warputils.common.language.MessageManager;
import com.etfl.warputils.common.utils.DataSaver;
import com.etfl.warputils.common.utils.EventBus;
import com.etfl.warputils.common.utils.FeatureValidator;
import com.etfl.warputils.features.warps.WarpHelper;
import com.etfl.warputils.features.warps.WarpRegistry;
import com.etfl.warputils.features.warps.data.WarpManager;

public class RenamewarpCommand {
    private RenamewarpCommand() {
        throw new UnsupportedOperationException("Utility class");
    }

    public static void register() {
        EventBus.addCommand((LiteralCommandBuilder)((LiteralCommandBuilder)LiteralCommandBuilder.literal("renamewarp").requires(CommandSourceWrapper::isPlayer)).then(ArgumentCommandBuilder.argument("currentName", StringArgumentWrapper.word()).suggests(WarpRegistry.SUGGESTION_PROVIDER(false)).then(ArgumentCommandBuilder.argument("newName", StringArgumentWrapper.word()).suggests(WarpRegistry.SUGGESTION_PROVIDER(false)).executes(RenamewarpCommand::run))));
    }

    private static int run(CommandContextWrapper context) {
        ServerPlayerWrapper player = context.getSource().getPlayer();
        String oldName = StringArgumentWrapper.getString(context, "oldName");
        String newName = StringArgumentWrapper.getString(context, "newName");
        if (FeatureValidator.disabled(FeatureValidator.Feature.Warp, player)) {
            return 0;
        }
        if (WarpHelper.noWarps(player)) {
            return 0;
        }
        if (WarpHelper.warpMissing(player, oldName)) {
            return 0;
        }
        if (oldName.equals(newName)) {
            return RenamewarpCommand.renamingFailed(player);
        }
        WarpManager.addWarp(newName, WarpManager.get(oldName));
        WarpManager.removeWarp(oldName);
        DataSaver.markDirty();
        MessageManager.sendMessage(player, "feature.homes.renamed", false, oldName, newName);
        return 1;
    }

    private static int renamingFailed(ServerPlayerWrapper player) {
        MessageManager.sendMessage(player, "feature.warp.renaming_failed", false, new Object[0]);
        return 0;
    }
}

