/*
 * Decompiled with CFR 0.152.
 */
package com.etfl.warputils.features.warps.commands;

import com.etfl.warputils.common.abstraction.commands.ArgumentCommandBuilder;
import com.etfl.warputils.common.abstraction.commands.LiteralCommandBuilder;
import com.etfl.warputils.common.abstraction.commands.wrappers.CommandContextWrapper;
import com.etfl.warputils.common.abstraction.commands.wrappers.CommandSourceWrapper;
import com.etfl.warputils.common.abstraction.commands.wrappers.argumentTypes.StringArgumentWrapper;
import com.etfl.warputils.common.abstraction.objects.ServerPlayerWrapper;
import com.etfl.warputils.common.language.MessageManager;
import com.etfl.warputils.common.utils.DataSaver;
import com.etfl.warputils.common.utils.EventBus;
import com.etfl.warputils.common.utils.FeatureValidator;
import com.etfl.warputils.features.warps.WarpRegistry;
import com.etfl.warputils.features.warps.data.WarpManager;

public class SetwarpCommand {
    private SetwarpCommand() {
        throw new UnsupportedOperationException("Utility class");
    }

    public static void register() {
        EventBus.addCommand((LiteralCommandBuilder)((LiteralCommandBuilder)((LiteralCommandBuilder)LiteralCommandBuilder.literal("setwarp").requires(CommandSourceWrapper::isPlayer)).requires(source -> source.hasPermissionLevel(2))).then(ArgumentCommandBuilder.argument("warpName", StringArgumentWrapper.word()).suggests(WarpRegistry.SUGGESTION_PROVIDER(false)).executes(SetwarpCommand::run)));
    }

    private static int run(CommandContextWrapper context) {
        ServerPlayerWrapper player = context.getSource().getPlayer();
        String warpName = StringArgumentWrapper.getString(context, "warpName");
        if (FeatureValidator.disabled(FeatureValidator.Feature.Warp, player)) {
            return 0;
        }
        WarpManager.addWarp(warpName, player.getLocation());
        DataSaver.markDirty();
        MessageManager.sendMessage(player, "feature.warp.set", false, warpName);
        return 1;
    }
}

