/*
 * Decompiled with CFR 0.152.
 */
package com.etfl.warputils.features.warps.data;

import com.etfl.warputils.common.abstraction.config.nbt.NbtCompound;
import com.etfl.warputils.common.data.Location;
import java.util.HashMap;
import java.util.Map;

public class WarpManager {
    private static final Map<String, Location> warps = new HashMap<String, Location>();

    private WarpManager() {
    }

    public static Location get(String warpName) {
        return warps.get(warpName);
    }

    public static String[] get() {
        return (String[])warps.keySet().toArray(String[]::new);
    }

    public static int getCount() {
        return warps.size();
    }

    public static void addWarp(String warpName, Location location) {
        if (warpName == null || location == null) {
            return;
        }
        warps.put(warpName, location);
    }

    public static boolean removeWarp(String warpName) {
        return warps.remove(warpName) != null;
    }

    public static void reset() {
        warps.clear();
    }

    public static NbtCompound toNbt() {
        NbtCompound nbt = new NbtCompound();
        if (warps.isEmpty()) {
            return nbt;
        }
        warps.forEach((warpName, location) -> nbt.putCompound((String)warpName, location.toNbt()));
        return nbt;
    }

    public static void fromNbt(NbtCompound nbt) {
        for (String key : nbt.getKeys()) {
            Location location;
            NbtCompound nbtCompound = nbt.getCompound(key).orElse(null);
            if (nbtCompound == null || (location = (Location)Location.fromNbt(nbtCompound).orElse(null)) == null) continue;
            warps.put(key, location);
        }
    }
}

