/*
 * Decompiled with CFR 0.152.
 */
package com.etfl.warputils.common.abstraction.config.settings;

import com.etfl.warputils.common.abstraction.commands.wrappers.CommandContextWrapper;
import com.etfl.warputils.common.abstraction.commands.wrappers.argumentTypes.BoolArgumentWrapper;
import com.etfl.warputils.common.abstraction.commands.wrappers.argumentTypes.IArgumentWrapper;
import com.etfl.warputils.common.abstraction.config.nbt.NbtCompound;
import com.etfl.warputils.common.abstraction.config.settings.ConfigSetting;

public class BoolConfigSetting
extends ConfigSetting<Boolean> {
    public BoolConfigSetting(String name, IArgumentWrapper<Boolean> argumentType, boolean defaultValue) {
        super(name, argumentType, defaultValue);
    }

    @Override
    Boolean getValue(CommandContextWrapper context) {
        return BoolArgumentWrapper.getBool(context, this.name);
    }

    @Override
    protected Boolean getOrDefault(Object obj) {
        return this.isValid(obj) ? (Boolean)obj : (Boolean)this.defaultValue;
    }

    @Override
    protected boolean isValid(Object obj) {
        return obj instanceof Boolean;
    }

    @Override
    public void toNbt(NbtCompound nbt) {
        nbt.putBoolean(this.name, (Boolean)this.value);
    }

    @Override
    public void fromNbt(NbtCompound nbt) {
        this.value = nbt.getBoolean(this.name).orElse((Boolean)this.defaultSupplier.get());
    }
}

