/*
 * Decompiled with CFR 0.152.
 */
package com.etfl.warputils.common.abstraction.config.settings;

import com.etfl.warputils.common.abstraction.commands.wrappers.CommandContextWrapper;
import com.etfl.warputils.common.abstraction.commands.wrappers.argumentTypes.IArgumentWrapper;
import com.etfl.warputils.common.abstraction.commands.wrappers.argumentTypes.LongArgumentWrapper;
import com.etfl.warputils.common.abstraction.config.nbt.NbtCompound;
import com.etfl.warputils.common.abstraction.config.settings.ConfigSetting;
import java.util.function.Predicate;

public class LongConfigSetting
extends ConfigSetting<Long> {
    private final Predicate<Long> validator;

    public LongConfigSetting(String name, IArgumentWrapper<Long> argumentType, long defaultValue) {
        super(name, argumentType, defaultValue);
        this.validator = l -> true;
    }

    public LongConfigSetting(String name, IArgumentWrapper<Long> argumentType, long defaultValue, Predicate<Long> validator) {
        super(name, argumentType, defaultValue);
        this.validator = validator;
    }

    @Override
    Long getValue(CommandContextWrapper context) {
        return LongArgumentWrapper.getLong(context, this.name);
    }

    @Override
    protected Long getOrDefault(Object value) {
        return this.isValid(value) ? ((Number)value).longValue() : ((Long)this.defaultValue).longValue();
    }

    @Override
    protected boolean isValid(Object value) {
        return value instanceof Number && this.validator.test(((Number)value).longValue());
    }

    @Override
    public void toNbt(NbtCompound nbt) {
        nbt.putLong(this.name, (Long)this.value);
    }

    @Override
    public void fromNbt(NbtCompound nbt) {
        this.value = nbt.getLong(this.name).orElse((Long)this.defaultSupplier.get());
    }
}

