/*
 * Decompiled with CFR 0.152.
 */
package com.etfl.warputils.common.effects;

import com.etfl.warputils.common.abstraction.config.nbt.NbtCompound;
import com.etfl.warputils.common.effects.charge.ChargeEffects;
import com.etfl.warputils.common.effects.config.EffectsConfig;
import com.etfl.warputils.common.effects.phase.PhaseEffects;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.UUID;

public class EffectsManager {
    private static final Map<UUID, ChargeEffects> chargeEffects = new HashMap<UUID, ChargeEffects>();
    private static final Map<UUID, PhaseEffects> teleportEffects = new HashMap<UUID, PhaseEffects>();
    private static final Map<UUID, PhaseEffects> arrivalEffects = new HashMap<UUID, PhaseEffects>();

    private EffectsManager() {
        throw new UnsupportedOperationException("Utility class");
    }

    public static ChargeEffects getChargeEffect(UUID uuid) {
        if (EffectsConfig.chargeEffectsEnforced()) {
            return EffectsConfig.getChargeEffect();
        }
        return chargeEffects.getOrDefault(uuid, EffectsConfig.getChargeEffect());
    }

    public static void setChargeEffect(UUID uuid, ChargeEffects chargeEffect) {
        if (chargeEffect == null) {
            chargeEffects.remove(uuid);
        } else {
            chargeEffects.put(uuid, chargeEffect);
        }
    }

    public static PhaseEffects getTeleportEffect(UUID uuid) {
        if (EffectsConfig.teleportEffectsEnforced()) {
            return EffectsConfig.getTeleportEffect();
        }
        return teleportEffects.getOrDefault(uuid, EffectsConfig.getTeleportEffect());
    }

    public static void setTeleportEffect(UUID uuid, PhaseEffects teleportEffect) {
        if (teleportEffect == null) {
            teleportEffects.remove(uuid);
        } else {
            teleportEffects.put(uuid, teleportEffect);
        }
    }

    public static PhaseEffects getArrivalEffect(UUID uuid) {
        if (EffectsConfig.arrivalEffectsEnforced()) {
            return EffectsConfig.getArrivalEffect();
        }
        return arrivalEffects.getOrDefault(uuid, EffectsConfig.getArrivalEffect());
    }

    public static void setArrivalEffect(UUID uuid, PhaseEffects teleportEffect) {
        if (teleportEffect == null) {
            arrivalEffects.remove(uuid);
        } else {
            arrivalEffects.put(uuid, teleportEffect);
        }
    }

    public static void reset() {
        chargeEffects.clear();
        teleportEffects.clear();
        arrivalEffects.clear();
    }

    public static NbtCompound toNbt() {
        NbtCompound nbt = new NbtCompound();
        HashSet<UUID> uuids = new HashSet<UUID>();
        uuids.addAll(chargeEffects.keySet());
        uuids.addAll(teleportEffects.keySet());
        uuids.addAll(arrivalEffects.keySet());
        for (UUID uuid : uuids) {
            PhaseEffects arrivalEffect;
            PhaseEffects teleportEffect;
            NbtCompound effectsCompound = new NbtCompound();
            ChargeEffects chargeEffect = chargeEffects.get(uuid);
            if (chargeEffect != null && !chargeEffect.equals(ChargeEffects.None)) {
                effectsCompound.putString("chargeEffect", chargeEffect.toString());
            }
            if ((teleportEffect = teleportEffects.get(uuid)) != null && !teleportEffect.equals(PhaseEffects.None)) {
                effectsCompound.putString("teleportEffect", teleportEffect.toString());
            }
            if ((arrivalEffect = arrivalEffects.get(uuid)) != null && !arrivalEffect.equals(PhaseEffects.None)) {
                effectsCompound.putString("arrivalEffect", arrivalEffect.toString());
            }
            nbt.putCompound(uuid.toString(), effectsCompound);
        }
        return nbt;
    }

    public static void fromNbt(NbtCompound nbt) {
        for (String uuid : nbt.getKeys()) {
            PhaseEffects arrivalEffect;
            PhaseEffects teleportEffect;
            if (nbt.getCompound(uuid).isEmpty()) continue;
            NbtCompound nbtCompound = nbt.getCompound(uuid).get();
            ChargeEffects chargeEffect = ChargeEffects.None.fromString(nbtCompound.getString("chargeEffect").orElse(""));
            if (chargeEffect != null) {
                chargeEffects.put(UUID.fromString(uuid), chargeEffect);
            }
            if ((teleportEffect = PhaseEffects.None.fromString(nbtCompound.getString("teleportEffect").orElse(""))) != null) {
                teleportEffects.put(UUID.fromString(uuid), teleportEffect);
            }
            if ((arrivalEffect = PhaseEffects.None.fromString(nbtCompound.getString("arrivalEffect").orElse(""))) == null) continue;
            arrivalEffects.put(UUID.fromString(uuid), arrivalEffect);
        }
    }
}

