/*
 * Decompiled with CFR 0.152.
 */
package com.etfl.warputils.common.effects.config;

import com.etfl.warputils.common.abstraction.commands.ICommandBuilder;
import com.etfl.warputils.common.abstraction.commands.LiteralCommandBuilder;
import com.etfl.warputils.common.abstraction.commands.wrappers.CommandContextWrapper;
import com.etfl.warputils.common.abstraction.commands.wrappers.CommandSourceWrapper;
import com.etfl.warputils.common.abstraction.objects.ServerPlayerWrapper;
import com.etfl.warputils.common.effects.EffectsManager;
import com.etfl.warputils.common.effects.charge.ChargeEffects;
import com.etfl.warputils.common.effects.phase.PhaseEffects;
import com.etfl.warputils.common.language.MessageManager;
import com.etfl.warputils.common.utils.EventBus;

public class EffectCommands {
    private EffectCommands() {
        throw new UnsupportedOperationException("Utility class");
    }

    public static void register() {
        LiteralCommandBuilder chargeEffect = (LiteralCommandBuilder)((LiteralCommandBuilder)LiteralCommandBuilder.literal("chargeEffect").executes(EffectCommands::getChargeEffect)).then(LiteralCommandBuilder.literal("default").executes(context -> EffectCommands.setChargeEffect(context, null)));
        for (ChargeEffects value : ChargeEffects.values()) {
            chargeEffect.then(LiteralCommandBuilder.literal(value.toString()).executes(context -> EffectCommands.setChargeEffect(context, value)));
        }
        LiteralCommandBuilder teleportEffect = (LiteralCommandBuilder)((LiteralCommandBuilder)LiteralCommandBuilder.literal("teleportEffect").executes(EffectCommands::getTeleportEffect)).then(LiteralCommandBuilder.literal("default").executes(context -> EffectCommands.setTeleportEffect(context, null)));
        for (PhaseEffects value : PhaseEffects.values()) {
            teleportEffect.then(LiteralCommandBuilder.literal(value.toString()).executes(context -> EffectCommands.setTeleportEffect(context, value)));
        }
        LiteralCommandBuilder arrivalEffect = (LiteralCommandBuilder)((LiteralCommandBuilder)LiteralCommandBuilder.literal("arrivalEffect").executes(EffectCommands::getTeleportEffect)).then(LiteralCommandBuilder.literal("default").executes(context -> EffectCommands.setArrivalEffect(context, null)));
        for (PhaseEffects value : PhaseEffects.values()) {
            arrivalEffect.then(LiteralCommandBuilder.literal(value.toString()).executes(context -> EffectCommands.setArrivalEffect(context, value)));
        }
        LiteralCommandBuilder base = (LiteralCommandBuilder)((LiteralCommandBuilder)((LiteralCommandBuilder)((LiteralCommandBuilder)LiteralCommandBuilder.literal("effects").requires(CommandSourceWrapper::isPlayer)).then((ICommandBuilder)chargeEffect)).then((ICommandBuilder)teleportEffect)).then((ICommandBuilder)arrivalEffect);
        EventBus.addCommand((LiteralCommandBuilder)LiteralCommandBuilder.literal("warputils").then(LiteralCommandBuilder.literal("personal").then((ICommandBuilder)base)));
    }

    private static int getChargeEffect(CommandContextWrapper context) {
        ServerPlayerWrapper player = context.getSource().getPlayer();
        MessageManager.sendMessage(player, "common.effects.get_charge", true, EffectsManager.getChargeEffect(player.getUUID()));
        return 1;
    }

    private static int setChargeEffect(CommandContextWrapper context, ChargeEffects chargeEffect) {
        ServerPlayerWrapper player = context.getSource().getPlayer();
        EffectsManager.setChargeEffect(player.getUUID(), chargeEffect);
        MessageManager.sendMessage(player, "common.effects.set_charge", true, EffectsManager.getChargeEffect(player.getUUID()));
        return 1;
    }

    private static int getTeleportEffect(CommandContextWrapper context) {
        ServerPlayerWrapper player = context.getSource().getPlayer();
        MessageManager.sendMessage(player, "common.effects.get_teleport", true, EffectsManager.getTeleportEffect(player.getUUID()));
        return 1;
    }

    private static int setTeleportEffect(CommandContextWrapper context, PhaseEffects teleportEffect) {
        ServerPlayerWrapper player = context.getSource().getPlayer();
        EffectsManager.setTeleportEffect(player.getUUID(), teleportEffect);
        MessageManager.sendMessage(player, "common.effects.set_teleport", true, EffectsManager.getTeleportEffect(player.getUUID()));
        return 1;
    }

    private static int getArrivalEffect(CommandContextWrapper context) {
        ServerPlayerWrapper player = context.getSource().getPlayer();
        MessageManager.sendMessage(player, "common.effects.get_arrival", true, EffectsManager.getArrivalEffect(player.getUUID()));
        return 1;
    }

    private static int setArrivalEffect(CommandContextWrapper context, PhaseEffects arrivalEffect) {
        ServerPlayerWrapper player = context.getSource().getPlayer();
        EffectsManager.setArrivalEffect(player.getUUID(), arrivalEffect);
        MessageManager.sendMessage(player, "common.effects.set_arrival", true, EffectsManager.getArrivalEffect(player.getUUID()));
        return 1;
    }
}

