/*
 * Decompiled with CFR 0.152.
 */
package com.etfl.warputils.common.effects.phase;

import com.etfl.warputils.common.data.Vector3d;
import com.etfl.warputils.common.effects.phase.PhaseEffect;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;

public class AscFlameSpiralEffect
extends PhaseEffect {
    private static final double RADIUS = 2.0;

    @Override
    public int duration() {
        return 10;
    }

    @Override
    public boolean continuous() {
        return true;
    }

    @Override
    public int steps() {
        return 1;
    }

    @Override
    protected void run(double progress, Vector3d pos, ServerLevel level) {
        progress = Math.clamp(progress, 0.0, 1.0);
        this.drawCircle(progress, pos, level);
        for (int i = 0; i < 1; ++i) {
            progress -= 0.05;
            if ((progress = Math.clamp(progress, 0.0, 1.0)) == 0.0) break;
            this.drawCircle(progress, pos, level);
        }
    }

    private void drawCircle(double progress, Vector3d pos, ServerLevel level) {
        for (int degree = 0; degree < 360; degree += 40) {
            double radians = Math.toRadians((double)degree + 120.0 * progress);
            double radiusProgress = 2.0 * progress;
            double x = Math.cos(radians) * radiusProgress;
            double z = Math.sin(radians) * radiusProgress;
            double height = 0.4 * radiusProgress * radiusProgress;
            level.sendParticles((ParticleOptions)ParticleTypes.FLAME, pos.x() + x, pos.y() + height, pos.z() + z, 2, 0.0, 0.0, 0.0, 0.0);
        }
    }
}

