/*
 * Decompiled with CFR 0.152.
 */
package com.etfl.warputils.common.utils.timer.cooldown;

import com.etfl.warputils.common.abstraction.config.nbt.NbtCompound;
import com.etfl.warputils.common.abstraction.objects.ServerPlayerWrapper;
import com.etfl.warputils.common.language.MessageManager;
import com.etfl.warputils.common.utils.timer.cooldown.CooldownType;
import com.etfl.warputils.common.utils.timer.cooldown.Cooldowns;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;

public class CooldownManager {
    private static final Map<UUID, Cooldowns> cooldowns = new HashMap<UUID, Cooldowns>();

    private CooldownManager() {
        throw new UnsupportedOperationException("Utility class");
    }

    public static void startCooldown(CooldownType cooldownType, ServerPlayerWrapper player) {
        cooldowns.computeIfAbsent(player.getUUID(), uuid -> new Cooldowns()).startCooldown(cooldownType, player.getTime());
    }

    public static boolean onCooldown(CooldownType cooldownType, ServerPlayerWrapper player) {
        boolean onCooldown;
        Cooldowns cooldowns = CooldownManager.cooldowns.get(player.getUUID());
        if (cooldowns == null) {
            return false;
        }
        int cooldown = cooldowns.getCooldown(cooldownType, player.getTime());
        boolean bl = onCooldown = cooldown > 0;
        if (onCooldown) {
            MessageManager.sendMessage(player, "common.cooldowns.active", false, (int)Math.ceil((double)cooldown / 20.0));
        }
        return onCooldown;
    }

    public static int getCooldown(ServerPlayerWrapper player, CooldownType cooldownType) {
        Cooldowns cooldowns = CooldownManager.cooldowns.get(player.getUUID());
        if (cooldowns == null) {
            return 0;
        }
        return cooldowns.getCooldown(cooldownType, player.getTime());
    }

    public static void reset() {
        cooldowns.clear();
    }

    public static NbtCompound toNbt() {
        NbtCompound nbt = new NbtCompound();
        if (cooldowns.isEmpty()) {
            return nbt;
        }
        cooldowns.forEach((key, value) -> nbt.putCompound(key.toString(), value.toNbt()));
        return nbt;
    }

    public static void fromNbt(NbtCompound nbt) {
        for (String key : nbt.getKeys()) {
            Cooldowns cooldown = Cooldowns.fromNbt(nbt.getCompound(key).orElseGet(NbtCompound::new));
            cooldowns.put(UUID.fromString(key), cooldown);
        }
    }
}

