/*
 * Decompiled with CFR 0.152.
 */
package com.etfl.warputils.common.utils.timer.delay;

import com.etfl.warputils.common.abstraction.objects.ServerPlayerWrapper;
import com.etfl.warputils.common.data.Vector3d;
import com.etfl.warputils.common.effects.EffectHandler;
import com.etfl.warputils.common.effects.EffectTask;
import com.etfl.warputils.common.effects.EffectsManager;
import com.etfl.warputils.common.effects.charge.IChargeEffect;
import com.etfl.warputils.common.effects.config.EffectsConfig;
import com.etfl.warputils.common.effects.phase.PhaseEffects;
import com.etfl.warputils.common.language.MessageManager;
import com.etfl.warputils.common.utils.timer.delay.DelayType;
import java.util.function.BiConsumer;
import java.util.function.Consumer;

class Delay {
    private int remainingTicks;
    private final BiConsumer<ServerPlayerWrapper, Integer> delayMessage;
    private final ServerPlayerWrapper player;
    private final Vector3d initialPosition;
    private final Consumer<ServerPlayerWrapper> teleportAction;
    private final EffectTask chargeEffect;
    private final PhaseEffects teleportEffect;
    private final PhaseEffects arrivalEffect;

    public Delay(DelayType delayType, ServerPlayerWrapper player, Consumer<ServerPlayerWrapper> teleportAction) {
        this.remainingTicks = delayType.get();
        this.delayMessage = delayType::message;
        this.player = player;
        this.initialPosition = player.getLocation().pos();
        this.teleportAction = teleportAction;
        if (EffectsConfig.disabled()) {
            this.chargeEffect = null;
            this.teleportEffect = null;
            this.arrivalEffect = null;
            return;
        }
        IChargeEffect effect = EffectsManager.getChargeEffect(player.getUUID()).get();
        if (effect != null) {
            this.chargeEffect = new EffectTask(effect, this.initialPosition, player.getLevel(), delayType.get());
            EffectHandler.play(this.chargeEffect);
        } else {
            this.chargeEffect = null;
        }
        this.teleportEffect = EffectsManager.getTeleportEffect(player.getUUID());
        this.arrivalEffect = EffectsManager.getArrivalEffect(player.getUUID());
    }

    public void onTick() {
        if (this.remainingTicks <= 0) {
            return;
        }
        if (this.remainingTicks % 20 == 0) {
            this.delayMessage.accept(this.player, this.remainingTicks);
        }
        --this.remainingTicks;
        if (this.remainingTicks == 0) {
            if (this.teleportEffect != null) {
                this.teleportEffect.play(this.player);
            }
            this.teleportAction.accept(this.player);
            if (this.arrivalEffect != null) {
                this.arrivalEffect.play(this.player);
            }
            this.remainingTicks = -1;
            return;
        }
        if (!this.player.closeTo(this.initialPosition, 0.2)) {
            this.remainingTicks = -1;
            MessageManager.sendMessage(this.player, "common.delay.moved", false, new Object[0]);
            EffectHandler.stop(this.chargeEffect);
        }
    }

    public boolean isInactive() {
        return this.remainingTicks < 0;
    }
}

