/*
 * Decompiled with CFR 0.152.
 */
package com.etfl.warputils.features.back.data;

import com.etfl.warputils.common.abstraction.config.nbt.NbtCompound;
import com.etfl.warputils.common.abstraction.objects.ServerPlayerWrapper;
import com.etfl.warputils.common.data.Location;
import com.etfl.warputils.features.back.data.BackData;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BackManager {
    private static final Map<UUID, BackData> backs = new HashMap<UUID, BackData>();

    private BackManager() {
        throw new UnsupportedOperationException("Utility class");
    }

    public static void add(@NotNull ServerPlayerWrapper player) {
        backs.put(player.getUUID(), new BackData(player.getLocation(), player.getTime()));
    }

    public static void remove(UUID uuid) {
        backs.remove(uuid);
    }

    public static boolean backPresent(UUID uuid, long currentTime) {
        if (backs.get(uuid) == null) {
            return false;
        }
        if (backs.get(uuid).isActive(currentTime)) {
            return true;
        }
        backs.remove(uuid);
        return false;
    }

    @Nullable
    public static Location getLocation(UUID uuid) {
        return backs.get(uuid) != null ? backs.get(uuid).getLocation() : null;
    }

    public static void reset() {
        backs.clear();
    }

    @NotNull
    public static NbtCompound toNbt() {
        NbtCompound nbt = new NbtCompound();
        if (backs.isEmpty()) {
            return nbt;
        }
        backs.forEach((uuid, backData) -> nbt.putCompound(uuid.toString(), backData.toNbt()));
        return nbt;
    }

    public static void fromNbt(NbtCompound nbt) {
        for (String key : nbt.getKeys()) {
            Optional<BackData> backData;
            Optional<NbtCompound> nbtCompound = nbt.getCompound(key);
            if (nbtCompound.isEmpty() || (backData = BackData.fromNbt(nbtCompound.get())).isEmpty()) continue;
            backs.put(UUID.fromString(key), backData.get());
        }
    }
}

