/*
 * Decompiled with CFR 0.152.
 */
package com.etfl.warputils.features.homes;

import com.etfl.warputils.common.abstraction.objects.ServerPlayerWrapper;
import com.etfl.warputils.common.language.MessageManager;
import com.etfl.warputils.features.homes.HomesConfig;
import com.etfl.warputils.features.homes.data.HomesManager;

public class HomesHelper {
    private HomesHelper() {
        throw new UnsupportedOperationException("Utility class");
    }

    public static boolean noHomes(ServerPlayerWrapper player) {
        int homeCount = HomesManager.getCount(player.getUUID());
        if (homeCount > 0) {
            return false;
        }
        MessageManager.sendMessage(player, "feature.homes.empty", false, new Object[0]);
        return true;
    }

    public static boolean invalidHomeCount(ServerPlayerWrapper player) {
        int maxHomeCount;
        int homeCount = HomesManager.getCount(player.getUUID());
        if (homeCount > (maxHomeCount = HomesConfig.getMaxHomeCount())) {
            MessageManager.sendMessage(player, "feature.homes.invalidHomeCount", false, homeCount, maxHomeCount);
            return true;
        }
        return false;
    }

    public static boolean homeMissing(ServerPlayerWrapper player, String homeName) {
        if (HomesManager.get(player.getUUID(), homeName) == null) {
            MessageManager.sendMessage(player, "feature.homes.not_found", false, homeName);
            return true;
        }
        return false;
    }
}

