/*
 * Decompiled with CFR 0.152.
 */
package com.etfl.warputils.features.homes.commands;

import com.etfl.warputils.common.abstraction.commands.ArgumentCommandBuilder;
import com.etfl.warputils.common.abstraction.commands.LiteralCommandBuilder;
import com.etfl.warputils.common.abstraction.commands.wrappers.CommandContextWrapper;
import com.etfl.warputils.common.abstraction.commands.wrappers.CommandSourceWrapper;
import com.etfl.warputils.common.abstraction.commands.wrappers.argumentTypes.StringArgumentWrapper;
import com.etfl.warputils.common.abstraction.objects.ServerPlayerWrapper;
import com.etfl.warputils.common.data.Location;
import com.etfl.warputils.common.language.MessageManager;
import com.etfl.warputils.common.utils.DataSaver;
import com.etfl.warputils.common.utils.EventBus;
import com.etfl.warputils.common.utils.FeatureValidator;
import com.etfl.warputils.common.utils.timer.cooldown.CooldownManager;
import com.etfl.warputils.common.utils.timer.cooldown.CooldownType;
import com.etfl.warputils.common.utils.timer.delay.DelayManager;
import com.etfl.warputils.common.utils.timer.delay.DelayType;
import com.etfl.warputils.common.utils.timer.fightCooldown.FightCooldownManager;
import com.etfl.warputils.features.back.data.BackManager;
import com.etfl.warputils.features.homes.HomesHelper;
import com.etfl.warputils.features.homes.HomesRegistry;
import com.etfl.warputils.features.homes.data.HomesManager;

public class HomeCommand {
    private HomeCommand() {
        throw new UnsupportedOperationException("Utility class");
    }

    public static void register() {
        EventBus.addCommand((LiteralCommandBuilder)((LiteralCommandBuilder)((LiteralCommandBuilder)LiteralCommandBuilder.literal("home").requires(CommandSourceWrapper::isPlayer)).executes(HomeCommand::runDefault)).then(ArgumentCommandBuilder.argument("homeName", StringArgumentWrapper.word()).suggests(HomesRegistry.SUGGESTION_PROVIDER).executes(HomeCommand::runNormal)));
    }

    private static int runNormal(CommandContextWrapper context) {
        return HomeCommand.run(context.getSource().getPlayer(), StringArgumentWrapper.getString(context, "homeName"));
    }

    private static int runDefault(CommandContextWrapper context) {
        ServerPlayerWrapper player = context.getSource().getPlayer();
        return HomeCommand.run(player, HomesManager.getDefaultHome(player.getUUID()));
    }

    private static int run(ServerPlayerWrapper player, String homeName) {
        if (FeatureValidator.disabled(FeatureValidator.Feature.Home, player)) {
            return 0;
        }
        if (HomesHelper.noHomes(player)) {
            return 0;
        }
        if (HomesHelper.invalidHomeCount(player)) {
            return 0;
        }
        if (HomesHelper.homeMissing(player, homeName)) {
            return 0;
        }
        if (CooldownManager.onCooldown(CooldownType.Home, player)) {
            return 0;
        }
        if (FightCooldownManager.onCooldown(player)) {
            return 0;
        }
        Location home = HomesManager.get(player.getUUID(), homeName);
        DelayManager.startDelay(DelayType.Home, player, player1 -> HomeCommand.teleport(player1, home, homeName));
        return 1;
    }

    private static void teleport(ServerPlayerWrapper player, Location home, String homeName) {
        BackManager.add(player);
        player.teleport(home);
        CooldownManager.startCooldown(CooldownType.Home, player);
        MessageManager.sendMessage(player, "feature.homes.teleported", false, homeName);
        DataSaver.markDirty();
    }
}

