/*
 * Decompiled with CFR 0.152.
 */
package com.etfl.warputils.features.homes.commands;

import com.etfl.warputils.common.abstraction.commands.LiteralCommandBuilder;
import com.etfl.warputils.common.abstraction.commands.wrappers.CommandContextWrapper;
import com.etfl.warputils.common.abstraction.commands.wrappers.CommandSourceWrapper;
import com.etfl.warputils.common.abstraction.objects.ServerPlayerWrapper;
import com.etfl.warputils.common.data.Location;
import com.etfl.warputils.common.language.MessageManager;
import com.etfl.warputils.common.utils.EventBus;
import com.etfl.warputils.common.utils.FeatureValidator;
import com.etfl.warputils.features.homes.HomesConfig;
import com.etfl.warputils.features.homes.HomesHelper;
import com.etfl.warputils.features.homes.data.HomesManager;
import java.util.UUID;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;

public class HomesCommand {
    private HomesCommand() {
        throw new UnsupportedOperationException("Utility class");
    }

    public static void register() {
        EventBus.addCommand((LiteralCommandBuilder)((LiteralCommandBuilder)LiteralCommandBuilder.literal("homes").requires(CommandSourceWrapper::isPlayer)).executes(HomesCommand::run));
    }

    private static int run(CommandContextWrapper context) {
        ServerPlayerWrapper player = context.getSource().getPlayer();
        if (FeatureValidator.disabled(FeatureValidator.Feature.Home, player)) {
            return 0;
        }
        if (HomesHelper.noHomes(player)) {
            return 0;
        }
        UUID uuid = player.getUUID();
        MessageManager.sendMessage(player, "feature.homes.list_begin", true, HomesManager.getCount(uuid), HomesConfig.getMaxHomeCount());
        for (String homeName : HomesManager.get(uuid)) {
            MessageManager.sendMessage(player, HomesCommand.homeMessage(homeName, uuid), true);
        }
        return 1;
    }

    private static Component homeMessage(String homeName, UUID uuid) {
        boolean defaultHome = HomesManager.getDefaultHome(uuid).equals(homeName);
        Location home = HomesManager.get(uuid, homeName);
        String position = String.format("%.1f, %.1f, %.1f", home.pos().x(), home.pos().y(), home.pos().z());
        return MessageManager.getMessage(uuid, "feature.homes.list_element", homeName, defaultHome ? "(default)" : "", position, home.dimension()).append((Component)MessageManager.getMessage(uuid, "feature.homes.list_edit", new Object[0]).withStyle(style -> style.withClickEvent((ClickEvent)new ClickEvent.SuggestCommand("/renamehome " + homeName + " ")))).append(" ").append((Component)MessageManager.getMessage(uuid, "feature.homes.list_delete", new Object[0]).withStyle(style -> style.withClickEvent((ClickEvent)new ClickEvent.SuggestCommand("/delhome " + homeName))));
    }
}

