/*
 * Decompiled with CFR 0.152.
 */
package com.etfl.warputils.features.homes.data;

import com.etfl.warputils.common.abstraction.config.nbt.NbtCompound;
import com.etfl.warputils.common.data.Location;
import com.etfl.warputils.features.homes.data.HomesData;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;

public class HomesManager {
    private static final Map<UUID, HomesData> homes = new HashMap<UUID, HomesData>();

    private HomesManager() {
        throw new UnsupportedOperationException("Utility class");
    }

    private static HomesData getData(UUID uuid) {
        return homes.computeIfAbsent(uuid, id -> new HomesData());
    }

    public static Location get(UUID uuid, String homeName) {
        return HomesManager.getData(uuid).get(homeName);
    }

    public static String[] get(UUID uuid) {
        return HomesManager.getData(uuid).get();
    }

    public static String getDefaultHome(UUID uuid) {
        return HomesManager.getData(uuid).getDefaultHomeName();
    }

    public static int getCount(UUID uuid) {
        return HomesManager.getData(uuid).getCount();
    }

    public static void addHome(UUID uuid, String homeName, Location location) {
        homes.computeIfAbsent(uuid, uuid1 -> new HomesData()).addHome(homeName, location);
    }

    public static boolean removeHome(UUID uuid, String homeName) {
        return HomesManager.getData(uuid).removeHome(homeName);
    }

    public static boolean setDefaultHome(UUID uuid, String homeName) {
        return HomesManager.getData(uuid).setDefaultHome(homeName);
    }

    public static void reset() {
        homes.clear();
    }

    public static NbtCompound toNbt() {
        NbtCompound nbt = new NbtCompound();
        if (homes.isEmpty()) {
            return nbt;
        }
        homes.forEach((uuid, homesData) -> {
            if (HomesManager.getData(uuid).getCount() == 0) {
                return;
            }
            nbt.putCompound(uuid.toString(), homesData.toNbt());
        });
        return nbt;
    }

    public static void fromNbt(NbtCompound nbt) {
        nbt.getKeys().forEach(key -> homes.put(UUID.fromString(key), HomesData.fromNbt(nbt.getCompound((String)key).get())));
    }
}

