/*
 * Decompiled with CFR 0.152.
 */
package com.etfl.warputils.common.abstraction.config.categories;

import com.etfl.warputils.common.abstraction.commands.ICommandBuilder;
import com.etfl.warputils.common.abstraction.commands.LiteralCommandBuilder;
import com.etfl.warputils.common.abstraction.config.ConfigComponent;
import com.etfl.warputils.common.abstraction.config.categories.ConfigCategory;
import com.etfl.warputils.common.abstraction.config.nbt.NbtCompound;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;

public class SimpleConfigCategory
implements ConfigCategory {
    private final String name;
    private final String commandName;
    private final List<ConfigComponent> components = new ArrayList<ConfigComponent>();
    private Supplier<Map<String, Object>> defaultSupplier = Map::of;

    public SimpleConfigCategory(String name) {
        this(name, name);
    }

    public SimpleConfigCategory(String name, String commandName) {
        this.name = name;
        this.commandName = commandName;
    }

    @Override
    public SimpleConfigCategory add(ConfigComponent component) {
        this.components.add(component);
        return this;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void initialize(LiteralCommandBuilder command) {
        LiteralCommandBuilder categoryCommand = LiteralCommandBuilder.literal(this.commandName);
        this.components.forEach(component -> component.initialize(categoryCommand));
        categoryCommand.then(((LiteralCommandBuilder)LiteralCommandBuilder.literal("reset").requires(source -> source.hasPermissionLevel(2))).executes(context -> this.setToDefault()));
        command.then((ICommandBuilder)categoryCommand);
    }

    private int setToDefault() {
        this.fromMap(this.defaultSupplier.get());
        return 1;
    }

    @Override
    public boolean validateOrSetDefault(@NotNull Map<String, Object> map) {
        Object obj = map.get(this.name);
        boolean incorrect = !(obj instanceof Map);
        LinkedHashMap<String, Object> categoryMap = incorrect ? new LinkedHashMap() : (Map)obj;
        for (ConfigComponent component : this.components) {
            incorrect |= component.validateOrSetDefault(categoryMap);
        }
        if (incorrect |= this.validateMapOrder(categoryMap)) {
            map.put(this.name, categoryMap);
        }
        return incorrect;
    }

    private boolean validateMapOrder(@NotNull Map<String, Object> map) {
        LinkedHashMap<String, Object> categoryMap = new LinkedHashMap<String, Object>(map);
        map.clear();
        this.components.forEach(component -> {
            String key = component.getName();
            map.put(key, categoryMap.get(key));
        });
        return !new ArrayList(categoryMap.keySet()).equals(new ArrayList<String>(map.keySet()));
    }

    @Override
    public void fromMap(@NotNull Map<String, Object> map) {
        Map m;
        Object object = map.get(this.name);
        Map categoryMap = object instanceof Map ? (m = (Map)object) : Map.of();
        this.components.forEach(component -> component.fromMap(categoryMap));
    }

    @Override
    public void setMarkDirtyRunnable(Runnable runnable) {
        this.components.forEach(component -> component.setMarkDirtyRunnable(runnable));
    }

    @Override
    public void setDefaultSupplier(Supplier<Map<String, Object>> supplier) {
        this.defaultSupplier = supplier;
        Supplier<Map> passedSupplier = () -> {
            Map m;
            Object patt0$temp = this.defaultSupplier.get().get(this.name);
            return patt0$temp instanceof Map ? (m = (Map)patt0$temp) : Map.of();
        };
        this.components.forEach(component -> component.setDefaultSupplier(passedSupplier));
    }

    @Override
    public void toNbt(NbtCompound nbt) {
        NbtCompound categoryNbt = new NbtCompound();
        this.components.forEach(component -> component.toNbt(categoryNbt));
        nbt.putCompound(this.name, categoryNbt);
    }

    @Override
    public void fromNbt(NbtCompound nbt) {
        Optional<NbtCompound> categoryNbt = nbt.getCompound(this.name);
        if (categoryNbt.isPresent()) {
            this.components.forEach(component -> component.fromNbt((NbtCompound)categoryNbt.get()));
        } else {
            this.fromMap(this.defaultSupplier.get());
        }
    }
}

