/*
 * Decompiled with CFR 0.152.
 */
package com.etfl.warputils.common.abstraction.config.fileManagement;

import com.etfl.warputils.common.abstraction.config.fileManagement.ConfigFileManager;
import com.etfl.warputils.platform.Services;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Function;
import org.apache.logging.log4j.core.config.plugins.validation.constraints.NotBlank;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class JsonConfigFileManager
implements ConfigFileManager {
    private final String configFileName;
    private final Function<Map<String, Object>, Boolean> configValidator;
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static final TypeToken<Map<String, Object>> TYPE_TOKEN = new TypeToken<Map<String, Object>>(){};

    public JsonConfigFileManager(@NotBlank @NotNull String configFileName, @Nullable Function<Map<String, Object>, Boolean> configValidator) {
        this.configFileName = configFileName;
        this.configValidator = configValidator != null ? configValidator : map -> false;
    }

    @Override
    public Map<String, Object> getConfig() {
        try {
            return this._getConfig();
        }
        catch (IOException e) {
            return new LinkedHashMap<String, Object>();
        }
    }

    private Map<String, Object> _getConfig() throws IOException {
        Path configPath = Services.PLATFORM.getConfigPath().resolve(this.configFileName + ".json");
        boolean fileExists = Files.exists(configPath, new LinkOption[0]);
        LinkedHashMap<String, Object> config = null;
        if (fileExists) {
            try (FileReader reader = new FileReader(configPath.toFile());){
                config = (Map)GSON.fromJson((Reader)reader, TYPE_TOKEN.getType());
            }
        }
        if (config == null) {
            config = new LinkedHashMap();
        }
        boolean changed = this.configValidator.apply(config);
        if (!fileExists || changed) {
            try (FileWriter writer = new FileWriter(configPath.toFile());){
                GSON.toJson(config, (Appendable)writer);
            }
        }
        return config;
    }
}

