/*
 * Decompiled with CFR 0.152.
 */
package com.etfl.warputils.common.abstraction.config.settings;

import com.etfl.warputils.common.abstraction.commands.ArgumentCommandBuilder;
import com.etfl.warputils.common.abstraction.commands.LiteralCommandBuilder;
import com.etfl.warputils.common.abstraction.commands.wrappers.CommandContextWrapper;
import com.etfl.warputils.common.abstraction.commands.wrappers.argumentTypes.IArgumentWrapper;
import com.etfl.warputils.common.abstraction.config.ConfigComponent;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.network.chat.Component;
import org.jetbrains.annotations.NotNull;

public abstract class ConfigSetting<T>
implements ConfigComponent {
    protected T value;
    protected final T defaultValue;
    protected final String name;
    protected final IArgumentWrapper<T> argumentType;
    protected Runnable markDirty = () -> {};
    protected Supplier<T> defaultSupplier;

    public ConfigSetting(String name, IArgumentWrapper<T> argumentType, T defaultValue) {
        this.name = name;
        this.argumentType = argumentType;
        this.value = defaultValue;
        this.defaultValue = defaultValue;
    }

    @Override
    @NotNull
    public String getName() {
        return this.name;
    }

    public T get() {
        return this.value;
    }

    @Override
    public void setMarkDirtyRunnable(@NotNull Runnable runnable) {
        this.markDirty = runnable;
    }

    @Override
    public void setDefaultSupplier(@NotNull Supplier<Map<String, Object>> supplier) {
        this.defaultSupplier = () -> this.getOrDefault(((Map)supplier.get()).get(this.name));
    }

    @Override
    public void initialize(@NotNull LiteralCommandBuilder command) {
        command.then(((LiteralCommandBuilder)((LiteralCommandBuilder)LiteralCommandBuilder.literal(this.name).executes(this::get)).then(((ArgumentCommandBuilder)ArgumentCommandBuilder.argument(this.name, this.argumentType).requires(source -> source.hasPermissionLevel(2))).executes(this::set))).then(((LiteralCommandBuilder)LiteralCommandBuilder.literal("default").requires(source -> source.hasPermissionLevel(2))).executes(this::reset)));
    }

    protected int get(CommandContextWrapper context) {
        context.getSource().sendSuccess(() -> Component.translatable((String)"commands.gamerule.query", (Object[])new Object[]{this.name, Component.literal((String)this.value.toString())}), false);
        return 1;
    }

    abstract T getValue(CommandContextWrapper var1);

    protected int set(CommandContextWrapper context) {
        this.markDirty.run();
        this.value = this.getValue(context);
        context.getSource().sendSuccess(() -> Component.translatable((String)"commands.gamerule.set", (Object[])new Object[]{this.name, Component.literal((String)this.value.toString())}), true);
        return 1;
    }

    protected int reset(CommandContextWrapper context) {
        this.markDirty.run();
        this.value = this.defaultSupplier.get();
        context.getSource().sendSuccess(() -> Component.translatable((String)"commands.gamerule.set", (Object[])new Object[]{this.name, Component.literal((String)this.value.toString())}), true);
        return 1;
    }

    @Override
    public boolean validateOrSetDefault(@NotNull Map<String, Object> map) {
        boolean incorrect;
        Object obj = map.get(this.name);
        boolean bl = incorrect = !this.isValid(obj);
        if (incorrect) {
            map.put(this.name, this.defaultValue);
        }
        return incorrect;
    }

    @Override
    public void fromMap(@NotNull Map<String, Object> map) {
        this.value = this.getOrDefault(map.get(this.name));
    }

    protected abstract T getOrDefault(Object var1);

    protected abstract boolean isValid(Object var1);
}

