/*
 * Decompiled with CFR 0.152.
 */
package com.etfl.warputils.common.abstraction.config.settings;

import com.etfl.warputils.common.abstraction.commands.ICommandBuilder;
import com.etfl.warputils.common.abstraction.commands.LiteralCommandBuilder;
import com.etfl.warputils.common.abstraction.commands.wrappers.CommandContextWrapper;
import com.etfl.warputils.common.abstraction.config.nbt.NbtCompound;
import com.etfl.warputils.common.abstraction.config.settings.ConfigSetting;
import com.etfl.warputils.common.abstraction.config.settings.EnumSettingType;
import java.util.Optional;
import net.minecraft.network.chat.Component;
import org.jetbrains.annotations.NotNull;

public class EnumConfigSetting<T extends Enum<T>>
extends ConfigSetting<T> {
    public EnumConfigSetting(String name, T defaultValue) {
        super(name, null, defaultValue);
    }

    @Override
    public void initialize(@NotNull LiteralCommandBuilder command) {
        LiteralCommandBuilder settingCommand = (LiteralCommandBuilder)((LiteralCommandBuilder)LiteralCommandBuilder.literal(this.name).executes(this::get)).then(((LiteralCommandBuilder)LiteralCommandBuilder.literal("default").requires(source -> source.hasPermissionLevel(2))).executes(this::reset));
        for (Enum value : (Enum[])((Enum)this.value).getDeclaringClass().getEnumConstants()) {
            settingCommand.then(((LiteralCommandBuilder)LiteralCommandBuilder.literal(value.toString()).requires(source -> source.hasPermissionLevel(2))).executes(context -> this.set(context, value)));
        }
        command.then((ICommandBuilder)settingCommand);
    }

    @Override
    T getValue(CommandContextWrapper context) {
        return null;
    }

    private int set(CommandContextWrapper context, T value) {
        this.markDirty.run();
        this.value = value;
        context.getSource().sendSuccess(() -> Component.translatable((String)"commands.gamerule.set", (Object[])new Object[]{this.name, Component.literal((String)value.toString())}), true);
        return 1;
    }

    @Override
    protected T getOrDefault(Object obj) {
        Object value = ((EnumSettingType)((Object)((Enum)this.value))).fromString(obj.toString());
        return (T)(value == null ? (Enum)this.defaultValue : value);
    }

    @Override
    protected boolean isValid(Object obj) {
        return obj instanceof String && ((EnumSettingType)((Object)((Enum)this.value))).fromString((String)obj) != null;
    }

    @Override
    public void toNbt(NbtCompound nbt) {
        nbt.putString(this.name, ((Enum)this.value).toString());
    }

    @Override
    public void fromNbt(NbtCompound nbt) {
        this.value = nbt.getString(this.name).flatMap(s -> Optional.ofNullable(((EnumSettingType)((Object)((Enum)this.defaultValue))).fromString((String)s))).orElse((Enum)this.defaultSupplier.get());
    }
}

