/*
 * Decompiled with CFR 0.152.
 */
package com.etfl.warputils.common.abstraction.config.settings;

import com.etfl.warputils.common.abstraction.commands.wrappers.CommandContextWrapper;
import com.etfl.warputils.common.abstraction.commands.wrappers.argumentTypes.FloatArgumentWrapper;
import com.etfl.warputils.common.abstraction.commands.wrappers.argumentTypes.IArgumentWrapper;
import com.etfl.warputils.common.abstraction.config.nbt.NbtCompound;
import com.etfl.warputils.common.abstraction.config.settings.ConfigSetting;
import java.util.function.Predicate;

public class FloatConfigSetting
extends ConfigSetting<Float> {
    private final Predicate<Float> validator;

    public FloatConfigSetting(String name, IArgumentWrapper<Float> argumentType, float defaultValue) {
        super(name, argumentType, Float.valueOf(defaultValue));
        this.validator = f -> true;
    }

    public FloatConfigSetting(String name, IArgumentWrapper<Float> argumentType, float defaultValue, Predicate<Float> validator) {
        super(name, argumentType, Float.valueOf(defaultValue));
        this.validator = validator;
    }

    @Override
    Float getValue(CommandContextWrapper context) {
        return Float.valueOf(FloatArgumentWrapper.getFloat(context, this.name));
    }

    @Override
    protected Float getOrDefault(Object value) {
        return Float.valueOf(this.isValid(value) ? ((Number)value).floatValue() : ((Float)this.defaultValue).floatValue());
    }

    @Override
    protected boolean isValid(Object value) {
        return value instanceof Number && this.validator.test(Float.valueOf(((Number)value).floatValue()));
    }

    @Override
    public void toNbt(NbtCompound nbt) {
        nbt.putFloat(this.name, ((Float)this.value).floatValue());
    }

    @Override
    public void fromNbt(NbtCompound nbt) {
        this.value = nbt.getFloat(this.name).filter(this.validator).orElse((Float)this.defaultSupplier.get());
    }
}

