/*
 * Decompiled with CFR 0.152.
 */
package com.etfl.warputils.common.effects.charge;

import com.etfl.warputils.common.data.Vector3d;
import com.etfl.warputils.common.effects.charge.IChargeEffect;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;

public class EnchantingRitualEffect
implements IChargeEffect {
    private static final double RADIUS = 2.0;
    private int duration;

    @Override
    public boolean continuous() {
        return true;
    }

    @Override
    public int steps(int duration) {
        this.duration = duration;
        return 1;
    }

    @Override
    public void run(double progress, Vector3d pos, ServerLevel level) {
        progress = Math.clamp(progress, 0.0, 1.0);
        this.drawCircle(progress, pos, level, 2.0);
        this.drawLine(progress, pos, level, 2.0, false);
        double innerProgress = Math.clamp((progress * 3.0 - 1.0) / 2.0, 0.0, 1.0);
        if (innerProgress == 0.0) {
            return;
        }
        this.drawCircle(innerProgress, pos, level, 1.0);
        this.drawLine(innerProgress, pos, level, 1.0, true);
    }

    private void drawCircle(double progress, Vector3d pos, ServerLevel level, double radius) {
        for (int degree = 0; degree < 360; degree += 15) {
            double radians = Math.toRadians((double)degree + progress * (double)this.duration);
            double x = Math.cos(radians) * radius;
            double z = Math.sin(radians) * radius;
            level.sendParticles((ParticleOptions)ParticleTypes.ENCHANT, pos.x() + x, pos.y() + 0.05, pos.z() + z, 1, 0.0, 0.0, 0.0, 0.0);
        }
    }

    private void drawLine(double progress, Vector3d pos, ServerLevel level, double radius, boolean inner) {
        double divider = inner ? 4.0 : 1.0;
        for (int degree = 0; degree < 360; degree += 45) {
            double radians = Math.toRadians(degree);
            double x = Math.cos(radians) * radius;
            double z = Math.sin(radians) * radius;
            for (double height = 0.0; height < 1.5 * progress; height += 0.1) {
                level.sendParticles((ParticleOptions)ParticleTypes.ENCHANT, pos.x() + x, pos.y() + 0.05 + height / (degree % 90 == 0 ? divider : 2.0), pos.z() + z, 1, 0.0, 0.0, 0.0, 0.0);
            }
        }
    }
}

