/*
 * Decompiled with CFR 0.152.
 */
package com.etfl.warputils.common.language;

import com.etfl.warputils.common.abstraction.commands.ICommandBuilder;
import com.etfl.warputils.common.abstraction.commands.LiteralCommandBuilder;
import com.etfl.warputils.common.abstraction.commands.wrappers.CommandContextWrapper;
import com.etfl.warputils.common.abstraction.objects.ServerPlayerWrapper;
import com.etfl.warputils.common.language.MessageManager;
import com.etfl.warputils.common.utils.DataSaver;
import com.etfl.warputils.common.utils.EventBus;
import com.etfl.warputils.features.general.MessageTarget;

public class LanguageCommand {
    private LanguageCommand() {
        throw new UnsupportedOperationException("Utility class");
    }

    public static void register() {
        LiteralCommandBuilder languageBase = (LiteralCommandBuilder)LiteralCommandBuilder.literal("language").executes(LanguageCommand::getLanguage);
        for (MessageManager.Language language : MessageManager.Language.values()) {
            languageBase.then(LiteralCommandBuilder.literal(language.toString()).executes(context -> LanguageCommand.setLanguage(context, language)));
        }
        LiteralCommandBuilder targetBase = (LiteralCommandBuilder)LiteralCommandBuilder.literal("messageTarget").executes(LanguageCommand::getTarget);
        for (MessageTarget target : MessageTarget.values()) {
            targetBase.then(LiteralCommandBuilder.literal(target.toString()).executes(context -> LanguageCommand.setTarget(context, target)));
        }
        EventBus.addCommand((LiteralCommandBuilder)LiteralCommandBuilder.literal("warputils").then(((LiteralCommandBuilder)LiteralCommandBuilder.literal("personal").then((ICommandBuilder)languageBase)).then((ICommandBuilder)targetBase)));
    }

    private static int setLanguage(CommandContextWrapper context, MessageManager.Language language) {
        ServerPlayerWrapper player = context.getSource().getPlayer();
        MessageManager.setLanguage(player.getUUID(), language);
        DataSaver.markDirty();
        MessageManager.sendMessage(player, "common.language.set", true, language.toString());
        return 1;
    }

    private static int getLanguage(CommandContextWrapper context) {
        ServerPlayerWrapper player = context.getSource().getPlayer();
        MessageManager.sendMessage(player, "common.language.get", true, new Object[]{MessageManager.getLanguage(player.getUUID())});
        return 1;
    }

    private static int setTarget(CommandContextWrapper context, MessageTarget target) {
        ServerPlayerWrapper player = context.getSource().getPlayer();
        MessageManager.setTarget(player.getUUID(), target);
        DataSaver.markDirty();
        MessageManager.sendMessage(player, "common.message_target.set", true, target.toString());
        return 1;
    }

    private static int getTarget(CommandContextWrapper context) {
        ServerPlayerWrapper player = context.getSource().getPlayer();
        MessageManager.sendMessage(player, "common.message_target.get", true, MessageManager.getTarget(player.getUUID()));
        return 1;
    }
}

