/*
 * Decompiled with CFR 0.152.
 */
package com.etfl.warputils.common.language;

import com.etfl.warputils.Constants;
import com.etfl.warputils.common.abstraction.config.nbt.NbtCompound;
import com.etfl.warputils.common.abstraction.objects.ServerPlayerWrapper;
import com.etfl.warputils.features.general.GeneralConfig;
import com.etfl.warputils.features.general.MessageTarget;
import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import org.jetbrains.annotations.NotNull;

public class MessageManager {
    private static final String colorDelimiter = "\\|\\|";
    private static final Gson GSON = new Gson();
    private static final Language fallbackLanguage = Language.en_us;
    private static final Map<Language, Map<String, String>> messages = new HashMap<Language, Map<String, String>>();
    private static final Map<UUID, Language> playerLocale = new HashMap<UUID, Language>();
    private static final Map<UUID, MessageTarget> messageTargets = new HashMap<UUID, MessageTarget>();
    private static final Map<String, ChatFormatting[]> colors = new HashMap<String, ChatFormatting[]>();
    private static final String TARGETS = "target";
    private static final String LANGUAGE = "language";

    private MessageManager() {
        throw new UnsupportedOperationException("Utility class");
    }

    public static void setLanguage(UUID uuid, Language language) {
        playerLocale.put(uuid, language);
    }

    public static Language getLanguage(UUID uuid) {
        Language language = playerLocale.get(uuid);
        return language != null ? language : fallbackLanguage;
    }

    public static void setTarget(UUID uuid, MessageTarget target) {
        messageTargets.put(uuid, target);
    }

    public static MessageTarget getTarget(UUID uuid) {
        MessageTarget target = messageTargets.get(uuid);
        return target != null ? target : GeneralConfig.getMessageTarget();
    }

    public static void reset() {
        playerLocale.clear();
        messageTargets.clear();
    }

    public static void initialize() {
        Type type = new TypeToken<Map<String, String>>(){}.getType();
        for (Language value : Language.values()) {
            Map langMessages = new HashMap();
            try (InputStreamReader reader = new InputStreamReader(Objects.requireNonNull(MessageManager.class.getResourceAsStream("/assets/lang/" + value.toString() + ".json")));){
                langMessages = (Map)GSON.fromJson((Reader)reader, type);
            }
            catch (Exception e) {
                Constants.LOGGER.error(e.getMessage());
            }
            messages.put(value, langMessages != null ? langMessages : new HashMap());
        }
        type = new TypeToken<Map<String, String[]>>(){}.getType();
        Map rawFormatting = new HashMap();
        try (InputStreamReader reader = new InputStreamReader(Objects.requireNonNull(MessageManager.class.getResourceAsStream("/assets/lang/colors.json")));){
            rawFormatting = (Map)GSON.fromJson((Reader)reader, type);
        }
        catch (Exception e) {
            Constants.LOGGER.error(e.getMessage());
        }
        for (Map.Entry entry : rawFormatting.entrySet()) {
            ChatFormatting[] formatting = new ChatFormatting[((String[])entry.getValue()).length];
            for (int i = 0; i < ((String[])entry.getValue()).length; ++i) {
                try {
                    formatting[i] = ChatFormatting.valueOf((String)((String[])entry.getValue())[i]);
                    continue;
                }
                catch (Exception e) {
                    Constants.LOGGER.error((String)entry.getKey() + ": has an invalid color value");
                    formatting[i] = ChatFormatting.WHITE;
                }
            }
            colors.put((String)entry.getKey(), formatting);
        }
    }

    public static void sendMessage(@NotNull ServerPlayerWrapper player, String translationKey, boolean forceChat, Object ... args) {
        MutableComponent message = MessageManager.getMessage(player.getUUID(), translationKey, args);
        player.sendMessage((Component)message, MessageManager.getTarget(player.getUUID()).equals(MessageTarget.Actionbar) && !forceChat);
    }

    public static MutableComponent getMessage(UUID uuid, String translationKey, Object ... args) {
        Language locale = playerLocale.getOrDefault(uuid, fallbackLanguage);
        String message = messages.getOrDefault((Object)locale, Map.of()).getOrDefault(translationKey, messages.get((Object)fallbackLanguage).get(translationKey));
        if (message == null) {
            return Component.literal((String)translationKey);
        }
        ChatFormatting[] partColors = colors.getOrDefault(translationKey, new ChatFormatting[]{ChatFormatting.WHITE});
        if (args.length == 0) {
            return Component.literal((String)message).withStyle(partColors[0]);
        }
        message = String.format(message, args);
        String[] messageParts = message.split(colorDelimiter);
        MutableComponent messageComponent = Component.literal((String)messageParts[0]).withStyle(partColors[0]);
        for (int i = 1; i < messageParts.length; ++i) {
            messageComponent.append((Component)Component.literal((String)messageParts[i]).withStyle(partColors[i < partColors.length ? i : 0]));
        }
        return messageComponent;
    }

    public static void sendMessage(@NotNull ServerPlayerWrapper player, Component message, boolean forceChat) {
        player.sendMessage(message, MessageManager.getTarget(player.getUUID()).equals(MessageTarget.Actionbar) && !forceChat);
    }

    public static Component clickable(UUID uuid, String key, String command) {
        return MessageManager.getMessage(uuid, key, new Object[0]).withStyle(style -> style.withClickEvent((ClickEvent)new ClickEvent.RunCommand(command)));
    }

    public static void fromNbt(NbtCompound nbt) {
        NbtCompound effects = nbt.getCompound(TARGETS).orElse(new NbtCompound());
        NbtCompound languages = nbt.getCompound(LANGUAGE).orElse(new NbtCompound());
        for (String uuid : effects.getKeys()) {
            MessageTarget target = MessageTarget.Actionbar.fromString(effects.getString(uuid).orElse(null));
            if (target == null) continue;
            messageTargets.put(UUID.fromString(uuid), target);
        }
        for (String uuid : languages.getKeys()) {
            Language locale = Language.fromString(languages.getString(uuid).orElse(null));
            if (locale == null) continue;
            playerLocale.put(UUID.fromString(uuid), locale);
        }
    }

    public static NbtCompound toNbt() {
        NbtCompound nbt = new NbtCompound();
        NbtCompound language = new NbtCompound();
        if (!playerLocale.isEmpty()) {
            for (UUID uuid : playerLocale.keySet()) {
                language.putString(uuid.toString(), playerLocale.get(uuid).toString());
            }
        }
        NbtCompound effects = new NbtCompound();
        if (!messageTargets.isEmpty()) {
            for (UUID uuid : messageTargets.keySet()) {
                effects.putString(uuid.toString(), messageTargets.get(uuid).toString());
            }
        }
        nbt.putCompound(TARGETS, effects);
        nbt.putCompound(LANGUAGE, language);
        return nbt;
    }

    public static enum Language {
        en_us;


        static Language fromString(String language) {
            for (Language l : Language.values()) {
                if (!l.toString().equalsIgnoreCase(language)) continue;
                return l;
            }
            return null;
        }
    }
}

