/*
 * Decompiled with CFR 0.152.
 */
package com.etfl.warputils.common.utils;

import com.etfl.warputils.common.abstraction.commands.LiteralCommandBuilder;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.server.MinecraftServer;

public class EventBus {
    private static final List<LiteralCommandBuilder> commandBuilders = new ArrayList<LiteralCommandBuilder>();
    private static final List<Consumer<MinecraftServer>> tickEvents = new ArrayList<Consumer<MinecraftServer>>();
    private static final List<Consumer<MinecraftServer>> serverStartEvents = new ArrayList<Consumer<MinecraftServer>>();

    private EventBus() {
        throw new UnsupportedOperationException("Utility class");
    }

    public static void addCommand(LiteralCommandBuilder literalCommandBuilder) {
        commandBuilders.add(literalCommandBuilder);
    }

    public static void registerCommands(CommandDispatcher<CommandSourceStack> dispatcher) {
        for (LiteralCommandBuilder cmd : commandBuilders) {
            dispatcher.register((LiteralArgumentBuilder)cmd.build());
        }
    }

    public static void registerTickEvents(Runnable event) {
        tickEvents.add(server -> event.run());
    }

    public static void registerTickEvents(Consumer<MinecraftServer> event) {
        tickEvents.add(event);
    }

    public static void onTick(MinecraftServer server) {
        tickEvents.forEach(event -> event.accept(server));
    }

    public static void registerServerStartEvents(Consumer<MinecraftServer> serverStartEvent) {
        serverStartEvents.add(serverStartEvent);
    }

    public static void onServerStart(MinecraftServer server) {
        for (Consumer<MinecraftServer> event : serverStartEvents) {
            event.accept(server);
        }
    }
}

