/*
 * Decompiled with CFR 0.152.
 */
package com.etfl.warputils.common.utils.timer.cooldown;

import com.etfl.warputils.common.abstraction.config.nbt.IDataCompound;
import com.etfl.warputils.common.abstraction.config.nbt.NbtCompound;
import com.etfl.warputils.common.utils.timer.cooldown.CooldownType;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

class Cooldowns {
    private final Map<CooldownType, Long> timestamps = new HashMap<CooldownType, Long>();

    Cooldowns() {
    }

    public void startCooldown(@NotNull CooldownType cooldownType, long currentTime) {
        this.timestamps.put(cooldownType, currentTime + (long)cooldownType.get());
    }

    public boolean onCooldown(@NotNull CooldownType cooldownType, long currentTime) {
        return this.getCooldown(cooldownType, currentTime) > 0;
    }

    public int getCooldown(@NotNull CooldownType cooldownType, long currentTime) {
        Long cooldownEndTime = this.timestamps.get((Object)cooldownType);
        if (cooldownEndTime == null || cooldownEndTime <= currentTime) {
            this.timestamps.remove((Object)cooldownType);
            return 0;
        }
        long targetEndTime = (long)cooldownType.get() + currentTime;
        if (cooldownEndTime > targetEndTime) {
            this.timestamps.put(cooldownType, targetEndTime);
            return cooldownType.get();
        }
        return (int)(cooldownEndTime - currentTime);
    }

    public IDataCompound toNbt() {
        NbtCompound nbt = new NbtCompound();
        this.timestamps.forEach((cooldownType, value) -> nbt.putLong(cooldownType.toString(), (long)value));
        return nbt;
    }

    public static Cooldowns fromNbt(NbtCompound nbt) {
        Cooldowns cooldowns = new Cooldowns();
        for (String cooldownType : nbt.getKeys()) {
            cooldowns.timestamps.put(CooldownType.valueOf(cooldownType), nbt.getLong(cooldownType).orElse(0L));
        }
        return cooldowns;
    }
}

