/*
 * Decompiled with CFR 0.152.
 */
package com.etfl.warputils.common.utils.timer.delay;

import com.etfl.warputils.common.abstraction.objects.ServerPlayerWrapper;
import com.etfl.warputils.common.effects.EffectsManager;
import com.etfl.warputils.common.effects.config.EffectsConfig;
import com.etfl.warputils.common.language.MessageManager;
import com.etfl.warputils.common.utils.EventBus;
import com.etfl.warputils.common.utils.timer.delay.Delay;
import com.etfl.warputils.common.utils.timer.delay.DelayType;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.function.Consumer;

public class DelayManager {
    private static final Map<UUID, Delay> delays = new HashMap<UUID, Delay>();
    private static final short CLEANUP_INTERVAL = 20;
    private static short tickCounter = 0;

    private DelayManager() {
        throw new UnsupportedOperationException("Utility class");
    }

    public static void startDelay(DelayType delayType, ServerPlayerWrapper player, Consumer<ServerPlayerWrapper> teleportAction) {
        DelayManager.cancelDelayIfPresent(player);
        if (delayType.get() == 0) {
            if (!EffectsConfig.disabled()) {
                EffectsManager.getTeleportEffect(player.getUUID()).play(player);
            }
            teleportAction.accept(player);
            if (!EffectsConfig.disabled()) {
                EffectsManager.getArrivalEffect(player.getUUID()).play(player);
            }
            return;
        }
        delays.put(player.getUUID(), new Delay(delayType, player, teleportAction));
    }

    public static void cancelDelayIfPresent(ServerPlayerWrapper player) {
        Delay delay = delays.remove(player.getUUID());
        if (delay == null || delay.isInactive()) {
            return;
        }
        MessageManager.sendMessage(player, "common.delay.cancelled", false, new Object[0]);
    }

    public static void reset() {
        delays.clear();
    }

    public static void register() {
        EventBus.registerTickEvents(DelayManager::onTick);
    }

    private static void onTick() {
        if (delays.isEmpty()) {
            return;
        }
        delays.forEach((uuid, delay) -> delay.onTick());
        tickCounter = (short)(tickCounter + 1);
        tickCounter = (short)(tickCounter % 20);
        if (tickCounter != 0) {
            return;
        }
        delays.entrySet().removeIf(entry -> ((Delay)entry.getValue()).isInactive());
    }
}

