/*
 * Decompiled with CFR 0.152.
 */
package com.etfl.warputils.features.homes;

import com.etfl.warputils.common.abstraction.commands.wrappers.argumentTypes.BoolArgumentWrapper;
import com.etfl.warputils.common.abstraction.commands.wrappers.argumentTypes.IntegerArgumentWrapper;
import com.etfl.warputils.common.abstraction.commands.wrappers.argumentTypes.TimeArgumentWrapper;
import com.etfl.warputils.common.abstraction.config.categories.ConfigCategory;
import com.etfl.warputils.common.abstraction.config.categories.SimpleConfigCategory;
import com.etfl.warputils.common.abstraction.config.settings.BoolConfigSetting;
import com.etfl.warputils.common.abstraction.config.settings.IntConfigSetting;
import com.etfl.warputils.features.general.GeneralConfig;

public class HomesConfig {
    private static final IntConfigSetting cooldown = new IntConfigSetting("cooldown", TimeArgumentWrapper.time(-1), -1, value -> value >= -1);
    private static final IntConfigSetting delay = new IntConfigSetting("delay", TimeArgumentWrapper.time(-1), -1, value -> value >= -1);
    private static final IntConfigSetting maxHomeCount = new IntConfigSetting("maxHomeCount", IntegerArgumentWrapper.integer(1), 3, value -> value >= 1);
    private static final BoolConfigSetting disableHomes = new BoolConfigSetting("disableHomes", BoolArgumentWrapper.bool(), false);
    public static final ConfigCategory category = new SimpleConfigCategory("homes").add(cooldown).add(delay).add(maxHomeCount).add(disableHomes);

    private HomesConfig() {
        throw new UnsupportedOperationException("Utility class");
    }

    public static int getCooldown() {
        return (Integer)cooldown.get() > -1 ? (Integer)cooldown.get() : GeneralConfig.getCooldown();
    }

    public static int getDelay() {
        return (Integer)delay.get() > -1 ? (Integer)delay.get() : GeneralConfig.getDelay();
    }

    public static int getMaxHomeCount() {
        return (Integer)maxHomeCount.get();
    }

    public static boolean areHomesDisabled() {
        return (Boolean)disableHomes.get();
    }
}

