/*
 * Decompiled with CFR 0.152.
 */
package com.etfl.warputils.features.homes.commands;

import com.etfl.warputils.common.abstraction.commands.ArgumentCommandBuilder;
import com.etfl.warputils.common.abstraction.commands.LiteralCommandBuilder;
import com.etfl.warputils.common.abstraction.commands.wrappers.CommandContextWrapper;
import com.etfl.warputils.common.abstraction.commands.wrappers.CommandSourceWrapper;
import com.etfl.warputils.common.abstraction.commands.wrappers.argumentTypes.StringArgumentWrapper;
import com.etfl.warputils.common.abstraction.objects.ServerPlayerWrapper;
import com.etfl.warputils.common.language.MessageManager;
import com.etfl.warputils.common.utils.DataSaver;
import com.etfl.warputils.common.utils.EventBus;
import com.etfl.warputils.common.utils.FeatureValidator;
import com.etfl.warputils.features.homes.HomesHelper;
import com.etfl.warputils.features.homes.HomesRegistry;
import com.etfl.warputils.features.homes.data.HomesManager;
import java.util.UUID;

public class RenamehomeCommand {
    private RenamehomeCommand() {
        throw new UnsupportedOperationException("Utility class");
    }

    public static void register() {
        EventBus.addCommand((LiteralCommandBuilder)((LiteralCommandBuilder)((LiteralCommandBuilder)LiteralCommandBuilder.literal("renamehome").requires(CommandSourceWrapper::isPlayer)).requires(source -> source.hasPermissionLevel(2))).then(ArgumentCommandBuilder.argument("currentName", StringArgumentWrapper.word()).suggests(HomesRegistry.SUGGESTION_PROVIDER).then(ArgumentCommandBuilder.argument("newName", StringArgumentWrapper.word()).suggests(HomesRegistry.SUGGESTION_PROVIDER).executes(RenamehomeCommand::run))));
    }

    private static int run(CommandContextWrapper context) {
        ServerPlayerWrapper player = context.getSource().getPlayer();
        String oldName = StringArgumentWrapper.getString(context, "oldName");
        String newName = StringArgumentWrapper.getString(context, "newName");
        if (FeatureValidator.disabled(FeatureValidator.Feature.Home, player)) {
            return 0;
        }
        if (HomesHelper.noHomes(player)) {
            return 0;
        }
        if (HomesHelper.homeMissing(player, oldName)) {
            return 0;
        }
        if (oldName.equals(newName)) {
            return RenamehomeCommand.renamingFailed(player);
        }
        UUID uuid = player.getUUID();
        HomesManager.addHome(uuid, newName, HomesManager.get(uuid, oldName));
        HomesManager.removeHome(uuid, oldName);
        DataSaver.markDirty();
        MessageManager.sendMessage(player, "feature.homes.renamed", false, oldName, newName);
        return 1;
    }

    private static int renamingFailed(ServerPlayerWrapper player) {
        MessageManager.sendMessage(player, "feature.homes.renaming_failed", false, new Object[0]);
        return 0;
    }
}

