/*
 * Decompiled with CFR 0.152.
 */
package com.etfl.warputils.features.tpas.commands;

import com.etfl.warputils.common.abstraction.commands.ArgumentCommandBuilder;
import com.etfl.warputils.common.abstraction.commands.LiteralCommandBuilder;
import com.etfl.warputils.common.abstraction.commands.wrappers.CommandContextWrapper;
import com.etfl.warputils.common.abstraction.commands.wrappers.CommandSourceWrapper;
import com.etfl.warputils.common.abstraction.commands.wrappers.ISuggestionProvider;
import com.etfl.warputils.common.abstraction.commands.wrappers.argumentTypes.EntityArgumentWrapper;
import com.etfl.warputils.common.abstraction.objects.ServerPlayerWrapper;
import com.etfl.warputils.common.language.MessageManager;
import com.etfl.warputils.common.utils.EventBus;
import com.etfl.warputils.common.utils.FeatureValidator;
import com.etfl.warputils.common.utils.PlayerHelper;
import com.etfl.warputils.common.utils.timer.cooldown.CooldownManager;
import com.etfl.warputils.common.utils.timer.cooldown.CooldownType;
import com.etfl.warputils.features.tpas.data.Tpa;
import com.etfl.warputils.features.tpas.data.TpaManager;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.List;
import java.util.UUID;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.network.chat.Component;
import org.jetbrains.annotations.NotNull;

public class TpaCommand {
    private static final ISuggestionProvider<CommandContextWrapper> SUGGESTION_PROVIDER = (context, builder) -> SharedSuggestionProvider.suggest(TpaCommand.getPlayersExcept(context), (SuggestionsBuilder)builder);

    private TpaCommand() {
        throw new UnsupportedOperationException("Utility class");
    }

    public static void register() {
        EventBus.addCommand((LiteralCommandBuilder)((LiteralCommandBuilder)LiteralCommandBuilder.literal("tpa").requires(CommandSourceWrapper::isPlayer)).then(ArgumentCommandBuilder.argument("target", EntityArgumentWrapper.player()).suggests(SUGGESTION_PROVIDER).executes(TpaCommand::run)));
    }

    private static List<String> getPlayersExcept(CommandContextWrapper context) {
        UUID sender = context.getSource().getPlayer().getUUID();
        return context.getSource().getServer().getPlayerList().getPlayers().stream().filter(player -> !player.getUUID().equals(sender)).map(player -> player.getName().getString()).toList();
    }

    private static int run(CommandContextWrapper context) throws CommandSyntaxException {
        ServerPlayerWrapper player = context.getSource().getPlayer();
        ServerPlayerWrapper target = EntityArgumentWrapper.getPlayer(context, "target");
        if (FeatureValidator.disabled(FeatureValidator.Feature.Tpa, player)) {
            return 0;
        }
        if (TpaCommand.selfTpa(player, target.getUUID())) {
            return 0;
        }
        if (CooldownManager.onCooldown(CooldownType.Tpa, player)) {
            return 0;
        }
        Tpa previous = TpaManager.addTpa(player.getUUID(), target);
        if (previous != null) {
            TpaCommand.cancelPrevious(previous, player);
        }
        MessageManager.sendMessage(player, TpaCommand.tpaSent(player.getUUID(), target.getName()), true);
        MessageManager.sendMessage(target, TpaCommand.tpaReceived(target.getUUID(), player.getName()), true);
        return 1;
    }

    public static boolean selfTpa(@NotNull ServerPlayerWrapper player, @NotNull UUID targetUUID) {
        if (!player.getUUID().equals(targetUUID)) {
            return false;
        }
        MessageManager.sendMessage(player, "feature.tpa.self_tpa", false, new Object[0]);
        return true;
    }

    private static void cancelPrevious(Tpa tpa, ServerPlayerWrapper player) {
        ServerPlayerWrapper prevTarget = PlayerHelper.getPlayer(player.getServer(), tpa.uuid);
        if (prevTarget == null) {
            return;
        }
        MessageManager.sendMessage(prevTarget, "feature.tpa.cancelled_target", false, player.getName());
    }

    private static Component tpaSent(UUID uuid, String targetName) {
        return MessageManager.getMessage(uuid, "feature.tpa.sent", targetName).append(MessageManager.clickable(uuid, "feature.tpa.sent_cancel", "/tpacancel"));
    }

    private static Component tpaReceived(UUID uuid, String sender) {
        return MessageManager.getMessage(uuid, "feature.tpa.received", sender).append(MessageManager.clickable(uuid, "feature.tpa.received_accept", "/tpaaccept " + sender)).append(" ").append(MessageManager.clickable(uuid, "feature.tpa.received_deny", "/tpadeny " + sender));
    }
}

