/*
 * Decompiled with CFR 0.152.
 */
package com.etfl.warputils.features.tpas.commands;

import com.etfl.warputils.common.abstraction.commands.LiteralCommandBuilder;
import com.etfl.warputils.common.abstraction.commands.wrappers.CommandContextWrapper;
import com.etfl.warputils.common.abstraction.commands.wrappers.CommandSourceWrapper;
import com.etfl.warputils.common.abstraction.objects.ServerPlayerWrapper;
import com.etfl.warputils.common.language.MessageManager;
import com.etfl.warputils.common.utils.EventBus;
import com.etfl.warputils.common.utils.FeatureValidator;
import com.etfl.warputils.features.tpas.data.Tpa;
import com.etfl.warputils.features.tpas.data.TpaManager;

public class TpacancelCommand {
    private TpacancelCommand() {
        throw new UnsupportedOperationException("Utility class");
    }

    public static void register() {
        EventBus.addCommand((LiteralCommandBuilder)((LiteralCommandBuilder)LiteralCommandBuilder.literal("tpacancel").requires(CommandSourceWrapper::isPlayer)).executes(TpacancelCommand::run));
    }

    private static int run(CommandContextWrapper context) {
        ServerPlayerWrapper player = context.getSource().getPlayer();
        if (FeatureValidator.disabled(FeatureValidator.Feature.Tpa, player)) {
            return 0;
        }
        Tpa tpa = TpaManager.sentBy(player.getUUID());
        if (tpa == null) {
            return TpacancelCommand.nonSent(player);
        }
        TpaManager.removeTpa(player.getUUID());
        MessageManager.sendMessage(player, "feature.tpa.cancelled", false, new Object[0]);
        MessageManager.sendMessage(player, "feature.tpa.cancelled_sender", true, new Object[0]);
        return 1;
    }

    private static int nonSent(ServerPlayerWrapper player) {
        MessageManager.sendMessage(player, "feature.tpa.non_sent", false, new Object[0]);
        return 0;
    }
}

