/*
 * Decompiled with CFR 0.152.
 */
package com.etfl.warputils.features.warps.commands;

import com.etfl.warputils.common.abstraction.commands.ArgumentCommandBuilder;
import com.etfl.warputils.common.abstraction.commands.LiteralCommandBuilder;
import com.etfl.warputils.common.abstraction.commands.wrappers.CommandContextWrapper;
import com.etfl.warputils.common.abstraction.commands.wrappers.CommandSourceWrapper;
import com.etfl.warputils.common.abstraction.commands.wrappers.argumentTypes.StringArgumentWrapper;
import com.etfl.warputils.common.abstraction.objects.ServerPlayerWrapper;
import com.etfl.warputils.common.data.Location;
import com.etfl.warputils.common.language.MessageManager;
import com.etfl.warputils.common.utils.DataSaver;
import com.etfl.warputils.common.utils.EventBus;
import com.etfl.warputils.common.utils.FeatureValidator;
import com.etfl.warputils.common.utils.timer.cooldown.CooldownManager;
import com.etfl.warputils.common.utils.timer.cooldown.CooldownType;
import com.etfl.warputils.common.utils.timer.delay.DelayManager;
import com.etfl.warputils.common.utils.timer.delay.DelayType;
import com.etfl.warputils.common.utils.timer.fightCooldown.FightCooldownManager;
import com.etfl.warputils.features.back.data.BackManager;
import com.etfl.warputils.features.warps.WarpConfig;
import com.etfl.warputils.features.warps.WarpHelper;
import com.etfl.warputils.features.warps.WarpRegistry;
import com.etfl.warputils.features.warps.data.WarpManager;

public class WarpCommand {
    private WarpCommand() {
        throw new UnsupportedOperationException("Utility class");
    }

    public static void register() {
        EventBus.addCommand((LiteralCommandBuilder)((LiteralCommandBuilder)LiteralCommandBuilder.literal("warp").requires(CommandSourceWrapper::isPlayer)).then(ArgumentCommandBuilder.argument("warpName", StringArgumentWrapper.word()).suggests(WarpRegistry.SUGGESTION_PROVIDER(true)).executes(WarpCommand::run)));
    }

    private static int run(CommandContextWrapper context) {
        boolean spawnWarp;
        ServerPlayerWrapper player = context.getSource().getPlayer();
        String warpName = StringArgumentWrapper.getString(context, "warpName");
        if (FeatureValidator.disabled(FeatureValidator.Feature.Warp, player)) {
            return 0;
        }
        boolean bl = spawnWarp = warpName.equals("Spawn") && !WarpConfig.isSpawnWarpDisabled();
        if (!spawnWarp && WarpHelper.noWarps(player)) {
            return 0;
        }
        if (!spawnWarp && WarpHelper.warpMissing(player, warpName)) {
            return 0;
        }
        if (CooldownManager.onCooldown(CooldownType.Warp, player)) {
            return 0;
        }
        if (FightCooldownManager.onCooldown(player)) {
            return 0;
        }
        Location warp = WarpManager.get(warpName);
        if (warp == null) {
            warp = player.getWorldSpawn();
        }
        Location finalWarp = warp;
        DelayManager.startDelay(DelayType.Home, player, player1 -> WarpCommand.teleport(player1, finalWarp, warpName));
        return 1;
    }

    private static void teleport(ServerPlayerWrapper player, Location warp, String warpName) {
        BackManager.add(player);
        player.teleport(warp);
        CooldownManager.startCooldown(CooldownType.Warp, player);
        MessageManager.sendMessage(player, "feature.warp.teleported", false, warpName);
        DataSaver.markDirty();
    }
}

