/*
 * Decompiled with CFR 0.152.
 */
package com.etfl.warputils.features.warps.commands;

import com.etfl.warputils.common.abstraction.commands.LiteralCommandBuilder;
import com.etfl.warputils.common.abstraction.commands.wrappers.CommandContextWrapper;
import com.etfl.warputils.common.abstraction.commands.wrappers.CommandSourceWrapper;
import com.etfl.warputils.common.abstraction.objects.ServerPlayerWrapper;
import com.etfl.warputils.common.language.MessageManager;
import com.etfl.warputils.common.utils.EventBus;
import com.etfl.warputils.common.utils.FeatureValidator;
import com.etfl.warputils.features.warps.WarpHelper;
import com.etfl.warputils.features.warps.data.WarpManager;
import java.util.UUID;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;

public class WarpsCommand {
    private WarpsCommand() {
        throw new UnsupportedOperationException("Utility class");
    }

    public static void register() {
        EventBus.addCommand((LiteralCommandBuilder)((LiteralCommandBuilder)LiteralCommandBuilder.literal("warps").requires(CommandSourceWrapper::isPlayer)).executes(WarpsCommand::run));
    }

    private static int run(CommandContextWrapper context) {
        ServerPlayerWrapper player = context.getSource().getPlayer();
        if (FeatureValidator.disabled(FeatureValidator.Feature.Warp, player)) {
            return 0;
        }
        if (WarpHelper.noWarps(player)) {
            return 0;
        }
        MessageManager.sendMessage(player, "feature.warp.list_begin", true, new Object[0]);
        for (String warpName : WarpManager.get()) {
            MessageManager.sendMessage(player, WarpsCommand.warpMessage(warpName, player.getUUID(), context.getSource().hasPermissionLevel(2)), true);
        }
        return 1;
    }

    private static Component warpMessage(String warpsName, UUID uuid, boolean operator) {
        MutableComponent message = MessageManager.getMessage(uuid, "feature.warp.list_element", warpsName);
        if (operator) {
            message.append((Component)MessageManager.getMessage(uuid, "feature.warp.list_edit", new Object[0]).withStyle(style -> style.withClickEvent((ClickEvent)new ClickEvent.SuggestCommand("/renamewarp " + warpsName + " ")))).append(" ").append((Component)MessageManager.getMessage(uuid, "feature.warp.list_delete", new Object[0]).withStyle(style -> style.withClickEvent((ClickEvent)new ClickEvent.SuggestCommand("/delwarp " + warpsName))));
        }
        return message;
    }
}

