/*
 * Decompiled with CFR 0.152.
 */
package me.novoro.cobblemonbroadcaster;

import com.mojang.brigadier.CommandDispatcher;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.ByteStreamsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import me.novoro.cobblemonbroadcaster.commands.BroadcastCommands;
import me.novoro.cobblemonbroadcaster.config.Configuration;
import me.novoro.cobblemonbroadcaster.config.YamlConfiguration;
import me.novoro.cobblemonbroadcaster.events.CaptureEvent;
import me.novoro.cobblemonbroadcaster.events.FaintEvent;
import me.novoro.cobblemonbroadcaster.events.SpawnEvent;
import me.novoro.cobblemonbroadcaster.util.BlacklistedWorlds;
import me.novoro.cobblemonbroadcaster.util.LangManager;
import me.novoro.cobblemonbroadcaster.util.PermissionHelper;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.command.v2.CommandRegistrationCallback;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.fabricmc.fabric.api.networking.v1.PacketSender;
import net.fabricmc.fabric.api.networking.v1.ServerPlayConnectionEvents;
import net.fabricmc.loader.api.FabricLoader;
import net.luckperms.api.LuckPermsProvider;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_3222;
import net.minecraft.class_3244;
import net.minecraft.class_7157;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 \u001d2\u00020\u0001:\u0001\u001dB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000f\u0010\u0005\u001a\u00020\u0004H\u0016\u00a2\u0006\u0004\b\u0005\u0010\u0003J\u000f\u0010\u0006\u001a\u00020\u0004H\u0002\u00a2\u0006\u0004\b\u0006\u0010\u0003J\u000f\u0010\u0007\u001a\u00020\u0004H\u0002\u00a2\u0006\u0004\b\u0007\u0010\u0003J\u000f\u0010\b\u001a\u00020\u0004H\u0002\u00a2\u0006\u0004\b\b\u0010\u0003J\r\u0010\t\u001a\u00020\u0004\u00a2\u0006\u0004\b\t\u0010\u0003J\u0015\u0010\r\u001a\u00020\f2\u0006\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0004\b\r\u0010\u000eJ\r\u0010\u000f\u001a\u00020\f\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u0017\u0010\u0012\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0004\b\u0012\u0010\u0013J!\u0010\u0016\u001a\u00020\u00042\b\u0010\u0014\u001a\u0004\u0018\u00010\f2\b\u0010\u0015\u001a\u0004\u0018\u00010\u0011\u00a2\u0006\u0004\b\u0016\u0010\u0017J\u000f\u0010\u0018\u001a\u00020\u0004H\u0002\u00a2\u0006\u0004\b\u0018\u0010\u0003J\u000f\u0010\u0019\u001a\u00020\u0004H\u0002\u00a2\u0006\u0004\b\u0019\u0010\u0003R\u0018\u0010\u001b\u001a\u0004\u0018\u00010\u001a8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u001b\u0010\u001c\u00a8\u0006\u001e"}, d2={"Lme/novoro/cobblemonbroadcaster/CobblemonBroadcaster;", "Lnet/fabricmc/api/ModInitializer;", "<init>", "()V", "", "onInitialize", "registerCommands", "registerServerLifecycleListeners", "setupPermissions", "configManager", "", "fileName", "Ljava/io/File;", "getOrCreateConfigurationFile", "(Ljava/lang/String;)Ljava/io/File;", "getConfigFolder", "()Ljava/io/File;", "Lme/novoro/cobblemonbroadcaster/config/Configuration;", "getConfig", "(Ljava/lang/String;)Lme/novoro/cobblemonbroadcaster/config/Configuration;", "file", "config", "saveConfig", "(Ljava/io/File;Lme/novoro/cobblemonbroadcaster/config/Configuration;)V", "displayAsciiArt", "registerEventListeners", "Lnet/minecraft/server/MinecraftServer;", "server", "Lnet/minecraft/server/MinecraftServer;", "Companion", "CobblemonBroadcaster"})
public final class CobblemonBroadcaster
implements ModInitializer {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private MinecraftServer server;
    @NotNull
    private static final Logger LOGGER;
    @NotNull
    private static final Map<UUID, Long> playerLoginTimes;
    @Nullable
    private static PermissionHelper perms;
    @Nullable
    private static Configuration mainConfig;

    public void onInitialize() {
        this.displayAsciiArt();
        this.configManager();
        LangManager.INSTANCE.loadConfig(mainConfig);
        this.registerCommands();
        this.registerServerLifecycleListeners();
    }

    private final void registerCommands() {
        CommandRegistrationCallback.EVENT.register(CobblemonBroadcaster::registerCommands$lambda$0);
    }

    private final void registerServerLifecycleListeners() {
        ServerLifecycleEvents.SERVER_STARTED.register(arg_0 -> CobblemonBroadcaster.registerServerLifecycleListeners$lambda$1(this, arg_0));
        ServerPlayConnectionEvents.JOIN.register(CobblemonBroadcaster::registerServerLifecycleListeners$lambda$2);
    }

    private final void setupPermissions() {
        try {
            LuckPermsProvider.get();
            perms = new PermissionHelper();
            LOGGER.info("Permissions system initialized!");
        }
        catch (Exception e) {
            LOGGER.error("Failed to initialize permissions system!", (Throwable)e);
        }
    }

    public final void configManager() {
        mainConfig = this.getConfig("config.yml");
        if (mainConfig == null) {
            LOGGER.error("Failed to load main configuration. Default values will be used.");
        } else {
            LOGGER.info("Configuration loaded successfully.");
        }
        Configuration blacklistConfig = this.getConfig("world-blacklist.yml");
        if (blacklistConfig == null) {
            LOGGER.error("Failed to load world-blacklist.yml!");
        } else {
            BlacklistedWorlds.INSTANCE.load(blacklistConfig);
            LOGGER.info("Blacklisted worlds loaded: {}", BlacklistedWorlds.INSTANCE.getGetblacklistedWorlds());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final File getOrCreateConfigurationFile(@NotNull String fileName) throws IOException {
        Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
        File configFolder = Companion.getConfigFolder();
        File configFile = new File(configFolder, fileName);
        if (!configFile.exists()) {
            configFolder.mkdirs();
            String resourcePath = "/CobblemonBroadcaster/" + fileName;
            InputStream inputStream = this.getClass().getResourceAsStream(resourcePath);
            if (inputStream == null) {
                throw new IOException("Default configuration file not found in resources: " + resourcePath);
            }
            InputStream resourceStream = inputStream;
            Closeable closeable = resourceStream;
            Throwable throwable = null;
            try {
                long l;
                InputStream input = (InputStream)closeable;
                boolean bl = false;
                Closeable closeable2 = new FileOutputStream(configFile);
                Throwable throwable2 = null;
                try {
                    FileOutputStream output = (FileOutputStream)closeable2;
                    boolean bl2 = false;
                    l = ByteStreamsKt.copyTo$default((InputStream)input, (OutputStream)output, (int)0, (int)2, null);
                }
                catch (Throwable throwable3) {
                    throwable2 = throwable3;
                    throw throwable3;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable2, (Throwable)throwable2);
                }
                long l2 = l;
            }
            catch (Throwable throwable4) {
                throwable = throwable4;
                throw throwable4;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        }
        return configFile;
    }

    @NotNull
    public final File getConfigFolder() {
        File configFolder = FabricLoader.getInstance().getConfigDir().resolve("cobblemonbroadcaster").toFile();
        if (!configFolder.exists()) {
            configFolder.mkdirs();
        }
        Intrinsics.checkNotNull((Object)configFolder);
        return configFolder;
    }

    @Nullable
    public final Configuration getConfig(@NotNull String fileName) {
        Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
        Configuration config = null;
        try {
            config = YamlConfiguration.loadConfiguration(this.getOrCreateConfigurationFile(fileName));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return config;
    }

    public final void saveConfig(@Nullable File file, @Nullable Configuration config) {
        try {
            if (config != null && file != null) {
                YamlConfiguration.save(config, file);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private final void displayAsciiArt() {
        LOGGER.info("CobblemonBroadcasters Loaded Successfully");
    }

    private final void registerEventListeners() {
        if (mainConfig != null && this.server != null) {
            Configuration configuration = mainConfig;
            Intrinsics.checkNotNull((Object)configuration);
            new SpawnEvent(configuration);
            Configuration configuration2 = mainConfig;
            Intrinsics.checkNotNull((Object)configuration2);
            MinecraftServer minecraftServer = this.server;
            Intrinsics.checkNotNull((Object)minecraftServer);
            new FaintEvent(configuration2, minecraftServer);
            Configuration configuration3 = mainConfig;
            Intrinsics.checkNotNull((Object)configuration3);
            v4 = new CaptureEvent(configuration3);
        } else {
            LOGGER.error("Failed to register events: mainConfig or server is null.");
            v4 = Unit.INSTANCE;
        }
        LOGGER.info("Event listeners registered!");
    }

    private static final void registerCommands$lambda$0(CommandDispatcher dispatcher, class_7157 registryAccess, class_2170.class_5364 environment) {
        Intrinsics.checkNotNull((Object)dispatcher);
        BroadcastCommands.INSTANCE.register((CommandDispatcher<class_2168>)dispatcher);
    }

    private static final void registerServerLifecycleListeners$lambda$1(CobblemonBroadcaster this$0, MinecraftServer minecraftServer) {
        this$0.server = minecraftServer;
        this$0.setupPermissions();
        this$0.registerEventListeners();
    }

    private static final void registerServerLifecycleListeners$lambda$2(class_3244 handler, PacketSender sender, MinecraftServer server) {
        Intrinsics.checkNotNullParameter((Object)handler, (String)"handler");
        class_3222 player = handler.field_14140;
        playerLoginTimes.put(player.method_5667(), System.currentTimeMillis());
    }

    static {
        Logger logger = LoggerFactory.getLogger((String)"cobblemonbroadcaster");
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(...)");
        LOGGER = logger;
        playerLoginTimes = new LinkedHashMap();
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000f\u0010\u0005\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\r\u0010\b\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\u0003R\u0017\u0010\n\u001a\u00020\t8\u0006\u00a2\u0006\f\n\u0004\b\n\u0010\u000b\u001a\u0004\b\f\u0010\rR#\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u00100\u000e8\u0006\u00a2\u0006\f\n\u0004\b\u0011\u0010\u0012\u001a\u0004\b\u0013\u0010\u0014R$\u0010\u0016\u001a\u0004\u0018\u00010\u00158\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u0016\u0010\u0017\u001a\u0004\b\u0018\u0010\u0019\"\u0004\b\u001a\u0010\u001bR\u0018\u0010\u001c\u001a\u0004\u0018\u00010\u00048\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u001c\u0010\u001dR\u0011\u0010!\u001a\u00020\u001e8F\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010 \u00a8\u0006\""}, d2={"Lme/novoro/cobblemonbroadcaster/CobblemonBroadcaster$Companion;", "", "<init>", "()V", "Lme/novoro/cobblemonbroadcaster/config/Configuration;", "getMainConfig", "()Lme/novoro/cobblemonbroadcaster/config/Configuration;", "", "reloadConfigurations", "Lorg/slf4j/Logger;", "LOGGER", "Lorg/slf4j/Logger;", "getLOGGER", "()Lorg/slf4j/Logger;", "", "Ljava/util/UUID;", "", "playerLoginTimes", "Ljava/util/Map;", "getPlayerLoginTimes", "()Ljava/util/Map;", "Lme/novoro/cobblemonbroadcaster/util/PermissionHelper;", "perms", "Lme/novoro/cobblemonbroadcaster/util/PermissionHelper;", "getPerms", "()Lme/novoro/cobblemonbroadcaster/util/PermissionHelper;", "setPerms", "(Lme/novoro/cobblemonbroadcaster/util/PermissionHelper;)V", "mainConfig", "Lme/novoro/cobblemonbroadcaster/config/Configuration;", "Ljava/io/File;", "getConfigFolder", "()Ljava/io/File;", "configFolder", "CobblemonBroadcaster"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Logger getLOGGER() {
            return LOGGER;
        }

        @NotNull
        public final Map<UUID, Long> getPlayerLoginTimes() {
            return playerLoginTimes;
        }

        @Nullable
        public final PermissionHelper getPerms() {
            return perms;
        }

        public final void setPerms(@Nullable PermissionHelper permissionHelper) {
            perms = permissionHelper;
        }

        @Nullable
        public final Configuration getMainConfig() {
            return mainConfig;
        }

        @NotNull
        public final File getConfigFolder() {
            File configFolder = FabricLoader.getInstance().getConfigDir().resolve("cobblemonbroadcaster").toFile();
            if (!configFolder.exists()) {
                configFolder.mkdirs();
            }
            Intrinsics.checkNotNull((Object)configFolder);
            return configFolder;
        }

        public final void reloadConfigurations() {
            try {
                mainConfig = YamlConfiguration.loadConfiguration(new CobblemonBroadcaster().getOrCreateConfigurationFile("config.yml"));
                LangManager.INSTANCE.loadConfig(mainConfig);
                this.getLOGGER().info("Cobblemon Broadcaster configuration reloaded successfully.");
                Configuration worldBlacklistConfig = YamlConfiguration.loadConfiguration(new CobblemonBroadcaster().getOrCreateConfigurationFile("world-blacklist.yml"));
                BlacklistedWorlds.INSTANCE.load(worldBlacklistConfig);
                this.getLOGGER().info("Blacklisted worlds reloaded: {}", BlacklistedWorlds.INSTANCE.getGetblacklistedWorlds());
            }
            catch (Exception e) {
                this.getLOGGER().error("Failed to reload configuration: " + e.getMessage(), (Throwable)e);
                throw e;
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

