/*
 * Decompiled with CFR 0.152.
 */
package me.novoro.cobblemonbroadcaster.config;

import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import me.novoro.cobblemonbroadcaster.CobblemonBroadcaster;
import me.novoro.cobblemonbroadcaster.config.Configuration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigVersionUpdater {
    private static final Logger LOGGER = LoggerFactory.getLogger(ConfigVersionUpdater.class);
    private final Configuration mainConfig;
    private final String currentVersion;

    public ConfigVersionUpdater(Configuration mainConfig, String currentVersion) {
        this.mainConfig = mainConfig;
        this.currentVersion = currentVersion;
    }

    public void updateConfig() {
        this.updateConfigFile(this.mainConfig, "config.yml");
    }

    private void updateConfigFile(Configuration config, String fileName) {
        String configVersion = config.getString("Config-Version", "1.0.0");
        if (this.isNewerVersion(configVersion, this.currentVersion)) {
            LOGGER.info("Updating " + fileName + " from version " + configVersion + " to " + this.currentVersion);
            config.set("Config-Version", this.currentVersion);
            this.saveConfigPreservingComments(new File(CobblemonBroadcaster.Companion.getConfigFolder(), fileName), this.currentVersion);
        } else {
            LOGGER.info(fileName + " is already up to date (version " + configVersion + "). No update needed.");
        }
    }

    private boolean isNewerVersion(String currentVersion, String newVersion) {
        String[] currentParts = currentVersion.split("\\.");
        String[] newParts = newVersion.split("\\.");
        int maxLength = Math.max(currentParts.length, newParts.length);
        for (int i = 0; i < maxLength; ++i) {
            int newPart;
            int currentPart = i < currentParts.length ? Integer.parseInt(currentParts[i]) : 0;
            int n = newPart = i < newParts.length ? Integer.parseInt(newParts[i]) : 0;
            if (currentPart < newPart) {
                return true;
            }
            if (currentPart <= newPart) continue;
            return false;
        }
        return false;
    }

    private void saveConfigPreservingComments(File file, String newVersion) {
        try {
            Path filePath = file.toPath();
            String originalContent = Files.readString(filePath, StandardCharsets.UTF_8);
            String updatedContent = originalContent.replaceFirst("(?m)^Config-Version: .*$", "Config-Version: " + newVersion);
            Path tempFilePath = filePath.getParent().resolve(String.valueOf(filePath.getFileName()) + ".tmp");
            Files.writeString(tempFilePath, (CharSequence)updatedContent, StandardCharsets.UTF_8, new OpenOption[0]);
            Files.move(tempFilePath, filePath, StandardCopyOption.REPLACE_EXISTING);
        }
        catch (IOException e) {
            LOGGER.error("Failed to preserve comments while saving config: " + file.getName(), (Throwable)e);
        }
    }
}

