/*
 * Decompiled with CFR 0.152.
 */
package me.novoro.cobblemonbroadcaster.config;

import com.google.common.base.Charsets;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.LinkedHashMap;
import me.novoro.cobblemonbroadcaster.config.Configuration;
import org.yaml.snakeyaml.DumperOptions;
import org.yaml.snakeyaml.LoaderOptions;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.constructor.BaseConstructor;
import org.yaml.snakeyaml.constructor.Constructor;
import org.yaml.snakeyaml.representer.Representer;

public final class YamlConfiguration {
    private static final ThreadLocal<Yaml> yaml = ThreadLocal.withInitial(() -> {
        DumperOptions options = new DumperOptions();
        options.setDefaultFlowStyle(DumperOptions.FlowStyle.BLOCK);
        options.setIndent(2);
        options.setPrettyFlow(true);
        Representer representer = new Representer(options){
            {
                this.representers.put(Configuration.class, data -> this.represent(((Configuration)data).self));
            }
        };
        return new Yaml((BaseConstructor)new Constructor(new LoaderOptions()), representer, options);
    });

    public static void save(Configuration config, File file) throws IOException {
        try (OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(file), Charsets.UTF_8);){
            YamlConfiguration.save(config, writer);
        }
    }

    public static void save(Configuration config, Writer writer) {
        yaml.get().dump(config.self, writer);
    }

    public static Configuration loadConfiguration(File file) throws IOException {
        return YamlConfiguration.loadConfiguration(file, null);
    }

    public static Configuration loadConfiguration(File file, Configuration defaults) throws IOException {
        try (FileInputStream is = new FileInputStream(file);){
            Configuration configuration = YamlConfiguration.loadConfiguration(is, defaults);
            return configuration;
        }
    }

    public static Configuration loadConfiguration(Reader reader) {
        return YamlConfiguration.loadConfiguration(reader, null);
    }

    public static Configuration loadConfiguration(Reader reader, Configuration defaults) {
        LinkedHashMap map = (LinkedHashMap)yaml.get().loadAs(reader, LinkedHashMap.class);
        if (map == null) {
            map = new LinkedHashMap();
        }
        return new Configuration(map, defaults);
    }

    public static Configuration loadConfiguration(InputStream is) {
        return YamlConfiguration.loadConfiguration(is, null);
    }

    public static Configuration loadConfiguration(InputStream is, Configuration defaults) {
        LinkedHashMap map = (LinkedHashMap)yaml.get().loadAs(is, LinkedHashMap.class);
        if (map == null) {
            map = new LinkedHashMap();
        }
        return new Configuration(map, defaults);
    }

    public static Configuration loadConfiguration(String string) {
        return YamlConfiguration.loadConfiguration(string, null);
    }

    public static Configuration loadConfiguration(String string, Configuration defaults) {
        LinkedHashMap map = (LinkedHashMap)yaml.get().loadAs(string, LinkedHashMap.class);
        if (map == null) {
            map = new LinkedHashMap();
        }
        return new Configuration(map, defaults);
    }
}

