/*
 * Decompiled with CFR 0.152.
 */
package me.novoro.cobblemonbroadcaster.util;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import me.novoro.cobblemonbroadcaster.config.Configuration;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010#\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0017\u0010\u0007\u001a\u00020\u00062\b\u0010\u0005\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0015\u0010\f\u001a\u00020\u000b2\u0006\u0010\n\u001a\u00020\t\u00a2\u0006\u0004\b\f\u0010\rR\u001a\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\t0\u000e8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u000f\u0010\u0010R\u0017\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\t0\u00118F\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006\u0015"}, d2={"Lme/novoro/cobblemonbroadcaster/util/BlacklistedWorlds;", "", "<init>", "()V", "Lme/novoro/cobblemonbroadcaster/config/Configuration;", "config", "", "load", "(Lme/novoro/cobblemonbroadcaster/config/Configuration;)V", "", "worldName", "", "isBlacklisted", "(Ljava/lang/String;)Z", "", "BLACKLISTED_WORLDS", "Ljava/util/Set;", "", "getGetblacklistedWorlds", "()Ljava/util/Set;", "getblacklistedWorlds", "CobblemonBroadcaster"})
public final class BlacklistedWorlds {
    @NotNull
    public static final BlacklistedWorlds INSTANCE = new BlacklistedWorlds();
    @NotNull
    private static final Set<String> BLACKLISTED_WORLDS = new HashSet();

    private BlacklistedWorlds() {
    }

    public final void load(@Nullable Configuration config) {
        BLACKLISTED_WORLDS.clear();
        if (config == null) {
            return;
        }
        List<String> list = config.getStringList("Blacklisted-Worlds");
        if (list != null) {
            BLACKLISTED_WORLDS.addAll((Collection<String>)list);
        }
    }

    public final boolean isBlacklisted(@NotNull String worldName) {
        Intrinsics.checkNotNullParameter((Object)worldName, (String)"worldName");
        return BLACKLISTED_WORLDS.contains(worldName);
    }

    @NotNull
    public final Set<String> getGetblacklistedWorlds() {
        Set<String> set = Collections.unmodifiableSet(BLACKLISTED_WORLDS);
        Intrinsics.checkNotNullExpressionValue(set, (String)"unmodifiableSet(...)");
        return set;
    }
}

