/*
 * Decompiled with CFR 0.152.
 */
package me.novoro.cobblemonbroadcaster.util;

import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.ComponentLike;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.TranslatableComponent;
import net.kyori.adventure.text.format.TextColor;
import net.kyori.adventure.text.format.TextDecoration;
import net.kyori.adventure.text.minimessage.MiniMessage;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0015\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0017\u0010\t\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0004H\u0002\u00a2\u0006\u0004\b\t\u0010\nJ\u0017\u0010\u000b\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0004H\u0002\u00a2\u0006\u0004\b\u000b\u0010\nJ\u0015\u0010\u000e\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\f\u00a2\u0006\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0011\u001a\u00020\u00108\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0011\u0010\u0012R\u0014\u0010\u0013\u001a\u00020\u00108\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0013\u0010\u0012R\u0014\u0010\u0015\u001a\u00020\u00148\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0015\u0010\u0016\u00a8\u0006\u0017"}, d2={"Lme/novoro/cobblemonbroadcaster/util/ColorUtil;", "", "<init>", "()V", "", "input", "Lnet/kyori/adventure/text/Component;", "parseColour", "(Ljava/lang/String;)Lnet/kyori/adventure/text/Component;", "replaceCodes", "(Ljava/lang/String;)Ljava/lang/String;", "getLegacyReplacement", "Lnet/kyori/adventure/text/ComponentLike;", "component", "componentToString", "(Lnet/kyori/adventure/text/ComponentLike;)Ljava/lang/String;", "Ljava/util/regex/Pattern;", "HEX_PATTERN", "Ljava/util/regex/Pattern;", "LEGACY_PATTERN", "Lnet/kyori/adventure/text/minimessage/MiniMessage;", "miniMessage", "Lnet/kyori/adventure/text/minimessage/MiniMessage;", "CobblemonBroadcaster"})
public final class ColorUtil {
    @NotNull
    public static final ColorUtil INSTANCE = new ColorUtil();
    @NotNull
    private static final Pattern HEX_PATTERN;
    @NotNull
    private static final Pattern LEGACY_PATTERN;
    @NotNull
    private static final MiniMessage miniMessage;

    private ColorUtil() {
    }

    @NotNull
    public final Component parseColour(@NotNull String input) {
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        String processedInput = this.replaceCodes(input);
        Component component = miniMessage.deserialize((Object)processedInput);
        Intrinsics.checkNotNullExpressionValue((Object)component, (String)"deserialize(...)");
        return component;
    }

    private final String replaceCodes(String input) {
        String result = input;
        Matcher hexMatcher = HEX_PATTERN.matcher(result);
        while (hexMatcher.find()) {
            String string = hexMatcher.group();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"group(...)");
            result = StringsKt.replace$default((String)result, (String)string, (String)("<reset><c:#" + hexMatcher.group(1) + ">"), (boolean)false, (int)4, null);
        }
        Matcher legacyMatcher = LEGACY_PATTERN.matcher(result);
        while (legacyMatcher.find()) {
            String string = legacyMatcher.group();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"group(...)");
            String string2 = legacyMatcher.group(1);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"group(...)");
            result = StringsKt.replace$default((String)result, (String)string, (String)this.getLegacyReplacement(string2), (boolean)false, (int)4, null);
        }
        return result;
    }

    private final String getLegacyReplacement(String input) {
        String string = input;
        Locale locale = Locale.ENGLISH;
        Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"ENGLISH");
        String string2 = string.toUpperCase(locale);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toUpperCase(...)");
        return switch (string2) {
            case "0" -> "<reset><c:#000000>";
            case "1" -> "<reset><c:#0000AA>";
            case "2" -> "<reset><c:#00AA00>";
            case "3" -> "<reset><c:#00AAAA>";
            case "4" -> "<reset><c:#AA0000>";
            case "5" -> "<reset><c:#AA00AA>";
            case "6" -> "<reset><c:#FFAA00>";
            case "7" -> "<reset><c:#AAAAAA>";
            case "8" -> "<reset><c:#555555>";
            case "9" -> "<reset><c:#5555FF>";
            case "A" -> "<reset><c:#55FF55>";
            case "B" -> "<reset><c:#55FFFF>";
            case "C" -> "<reset><c:#FF5555>";
            case "D" -> "<reset><c:#FF55FF>";
            case "E" -> "<reset><c:#FFFF55>";
            case "F" -> "<reset><c:#FFFFFF>";
            case "K" -> "<obf>";
            case "L" -> "<b>";
            case "M" -> "<st>";
            case "N" -> "<u>";
            case "O" -> "<i>";
            case "R" -> "<reset>";
            default -> input;
        };
    }

    @NotNull
    public final String componentToString(@NotNull ComponentLike component) {
        Intrinsics.checkNotNullParameter((Object)component, (String)"component");
        Component component2 = component.asComponent();
        Intrinsics.checkNotNullExpressionValue((Object)component2, (String)"asComponent(...)");
        Component styledComponent = component2;
        StringBuilder sb = new StringBuilder();
        Map map = styledComponent.decorations();
        Intrinsics.checkNotNullExpressionValue((Object)map, (String)"decorations(...)");
        for (Map.Entry entry : map.entrySet()) {
            TextDecoration key = (TextDecoration)entry.getKey();
            TextDecoration.State value = (TextDecoration.State)entry.getValue();
            if (value != TextDecoration.State.TRUE) continue;
            StringBuilder stringBuilder = sb.append("<");
            String string = key.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            String string2 = string.toLowerCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toLowerCase(...)");
            stringBuilder.append(string2).append(">");
        }
        TextColor color = styledComponent.color();
        if (color != null) {
            sb.append("<c:").append(color.asHexString()).append(">");
        }
        if (styledComponent instanceof TextComponent) {
            sb.append(((TextComponent)styledComponent).content());
        }
        if (styledComponent instanceof TranslatableComponent) {
            sb.append("<lang:").append(((TranslatableComponent)styledComponent).key()).append(">");
        }
        sb.append("<reset>");
        String string = sb.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    static {
        Pattern pattern = Pattern.compile("&#([A-Fa-f0-9]{6})");
        Intrinsics.checkNotNullExpressionValue((Object)pattern, (String)"compile(...)");
        HEX_PATTERN = pattern;
        Pattern pattern2 = Pattern.compile("[&\u00a7]([0-9a-fA-Fk-oK-OrR])");
        Intrinsics.checkNotNullExpressionValue((Object)pattern2, (String)"compile(...)");
        LEGACY_PATTERN = pattern2;
        MiniMessage miniMessage = MiniMessage.miniMessage();
        Intrinsics.checkNotNullExpressionValue((Object)miniMessage, (String)"miniMessage(...)");
        ColorUtil.miniMessage = miniMessage;
    }
}

