global.alienevo_alien_141 = ['mypowers:celestialsapien']; // Register your alien. Use an index value between 102 and 141
global.alienevo_randomization_141 = [false]; // Determine if you want your alien to be unlocked through mistransformation.

// INTERFACE VALUES
global.alienevo_regen_141 = [15]; // A faux regen value to represent your alien's healing capability. Values 0 thru 10. Does not effect gameplay.
global.alienevo_scale_141 = [55]; // Scale of the alien preview render. 55 is default
global.alienevo_textcolor_141 = [0xffffff]; // Text color of the alien species name
global.alienevo_background_141 = ['minecraft:textures/entity/end_portal.png']; // Tiled texture that appears behind the alien preview render



global.alienevo_descriptions = {};

global.getAlienDescription = function(id) {
    if (!(id in global.alienevo_descriptions)) {
        global.alienevo_descriptions[id] = Component.translatable(`alienevo.alien_desc.${id}`);
    }
    return global.alienevo_descriptions[id];
};



// COLOR PALETTES
// This is where you will define the default colors your model will use to support color customization.

// The "_uniforms" entries allow you to disable Glow, Primary, or Secondary tabs from appearing when editing the colors of your alien, dependent on uniform type.
global.alienevo_141_10k_uniforms = [true, true, true]; // Glow (enabled), Primary (enabled), Secondary (enabled)
global.alienevo_141_default_uniforms = [true, true, true]; // Glow (enabled), Primary (disabled), Secondary (disabled)
global.alienevo_141_prototype_uniforms = [true, true, true];

// Make sure your colors are listed from BRIGHTEST TO DARKEST. You can use as many or as few colors in a palette as you'd like.
global.alienevo_141_10k_skincolor_palette_1 = ["e5edfc", "c7def7", "a8d3f0"];
global.alienevo_141_10k_skincolor_palette_2 = ["e5edfc", "c7def7", "a8d3f0", "93bfdf"];
global.alienevo_141_10k_skincolor_palette_3 = ["ffffff", "ecf8fd", "e5edfc", "c7def7", "a8d3f0", "b0cce0"];

global.alienevo_141_default_skincolor_palette_1 = ["e5edfc", "c7def7", "a8d3f0"];
global.alienevo_141_default_skincolor_palette_2 = ["e5edfc", "c7def7", "a8d3f0", "93bfdf"];
global.alienevo_141_default_skincolor_palette_3 = ["ffffff", "ecf8fd", "e5edfc", "c7def7", "a8d3f0", "b0cce0"];

global.alienevo_141_prototype_skincolor_palette_1 = ["e5edfc", "c7def7", "a8d3f0"];
global.alienevo_141_prototype_skincolor_palette_2 = ["e5edfc", "c7def7", "a8d3f0", "93bfdf"];
global.alienevo_141_prototype_skincolor_palette_3 = ["ffffff", "ecf8fd", "e5edfc", "c7def7", "a8d3f0", "b0cce0"];

// GLOW COLOR PALETTES

// Glow color also accepts palettes of as many or as few colors as you choose.
// In this instance, I am using a single color instead of multiple shades.
global.alienevo_141_10k_glowcolor_1 = ["c7def7", "e5edfc"];
global.alienevo_141_10k_glowcolor_2 = ["75ef00", "67dc00", "51a300", "499600", "407e00", "366d00"];
global.alienevo_141_default_glowcolor_1 = ["c7def7", "e5edfc"];
global.alienevo_141_default_glowcolor_2 = ["75ef00", "67dc00", "51a300", "499600", "407e00", "366d00", "000000"];
global.alienevo_141_prototype_glowcolor_1 = ["e5edfc", "c7def7"];
global.alienevo_141_prototype_glowcolor_2 = ["75ef00", "67dc00", "51a300", "499600", "407e00", "366d00"];
// If your alien has more than one glow color, like XLR8 or Ripjaws, define it like this:
// global.alienevo_141_10k_glowcolor_2 = ["ffc833", "f1891f"];
// global.alienevo_141_default_glowcolor_2 = ["ffc833", "f1891f"];
// global.alienevo_141_prototype_glowcolor_2 = ["ffc833", "f1891f"];