PalladiumEvents.registerAnimations((event) => {
    event.register('mypowers/celestialsapien', 15, (builder) => {
        const player = builder.getPlayer();

        if (abilityUtil.isEnabled(player, "mypowers:celestialsapien", "celestialsapien_loop")) {
            if (!builder.isFirstPerson()) {
                builder.get('left_arm').rotateX(builder.getModel().leftArm.xRot * -0.4).moveX(0).moveY(0)
                builder.get('right_arm').rotateX(builder.getModel().rightArm.xRot * -0.4).moveX(-0).moveY(0)
                builder.get('right_leg').rotateX(builder.getModel().rightLeg.xRot * -0.4)
                builder.get('left_leg').rotateX(builder.getModel().leftLeg.xRot * -0.4)
            }

            // only apply crouch animation if NOT in debate dimension
            if (player.isCrouching() && player.level.dimension.toString() !== "mypowers:debate") {
                builder.get('head').setY(0)
                builder.get('chest').setXRotDegrees(20).setY(0)
                builder.get('left_leg').setY(10)
                builder.get('right_leg').setY(10)
                builder.get('left_arm').setY(2).setZ(1.5)
                builder.get('right_arm').setY(2).setZ(1.5)
            }
        }
    });
});
